/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.generator.ObservingSBGenerator;
import alma.obsprep.services.generator.WizardSBGenerationException;

public class StandardInterferometrySBGenerator
extends ObservingSBGenerator {
    static final String mode = "Standard Interferometry";
    private boolean suppressWarningDialog = false;

    public StandardInterferometrySBGenerator(ScienceGoal scienceGoal, ObsUnitSet obsUnitSet) {
        super(scienceGoal, obsUnitSet);
    }

    @Override
    protected void setupSBMode(SchedBlock schedBlock) {
        schedBlock.setModeName(mode);
        ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
        observingModeExpert.updateSchedBlock(schedBlock, mode);
    }

    @Override
    protected boolean canGenerate() throws WizardSBGenerationException {
        int n = this.scienceGoal.getTargetParametersCount();
        if (n == 0) {
            return false;
        }
        String string = this.scienceGoal.getSpectralSetupParameters().getType();
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            int n2 = spectralSetupParameters.getScienceSpectralWindowCount();
            if (n2 == 0) {
                throw new WizardSBGenerationException("Spectral Setup has no lines and no scans specified");
            }
        } else if (!string.equals(SpectralSetupParameters.TYPE_CONTINUUM) && string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            String string2 = "This version of the OT does not yet support SB generation for Spectral Scans";
            this.logger.warning(string2);
            throw new WizardSBGenerationException(string2);
        }
        return true;
    }

    public void suppressWarningDialog() {
        this.suppressWarningDialog = true;
    }
}

