/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.OUSStructureBuilder;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.Simultaneous12mAndACAOUSStructureBuilder;
import alma.obsprep.services.generator.refactored.StandardOUSStructureBuilder;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;

public class OUSStructureBuilderFactory {
    public static OUSStructureBuilderInterface getOUSStructureBuilder(OUSStructureTypesEnum oUSStructureTypesEnum, OUSGenerator oUSGenerator, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        OUSStructureBuilder oUSStructureBuilder = null;
        switch (oUSStructureTypesEnum) {
            case Simultaneous12mAndACAObserving: {
                oUSStructureBuilder = new Simultaneous12mAndACAOUSStructureBuilder(oUSGenerator, obsUnitSet, scienceGoal);
                break;
            }
            case StandardOUSStructure: {
                oUSStructureBuilder = new StandardOUSStructureBuilder(oUSGenerator, obsUnitSet, scienceGoal);
                break;
            }
            default: {
                String string = "Unknown OUS structure requested " + oUSStructureTypesEnum;
                Log.logger(OUSStructureBuilderFactory.class).warning(string);
                throw new WizardSBGenerationException(string);
            }
        }
        assert (oUSStructureBuilder != null);
        return oUSStructureBuilder;
    }

    public static enum OUSStructureTypesEnum {
        StandardOUSStructure,
        Simultaneous12mAndACAObserving;

    }
}

