/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;

public class SPWLinker {
    public void linkScienceSPWsInGroupOUSes(@NonNull ObsUnitSet obsUnitSet, @NonNull ScienceGoal scienceGoal) throws UnknownEntityException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        if (obsUnitSet == null) {
            throw new NullPointerException("groupOUS is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>(30);
        List<SchedBlock> list = obsUnitSet.findSchedBlocks();
        int n = MinTuningsCalculator.getLO1Tunings(scienceGoal).size();
        HashMap<SPWLabel, String> hashMap = new HashMap<SPWLabel, String>(30);
        for (int i = 1; i <= n; ++i) {
            for (SchedBlock schedBlock : list) {
                ObservingGroup observingGroup = schedBlock.getObservingGroup(i);
                List<Target> list2 = observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter);
                for (Target target : list2) {
                    SpectralSpec spectralSpec = target.getSpectralSpec();
                    if (hashSet.contains(spectralSpec)) continue;
                    hashSet.add(spectralSpec);
                    int n2 = 1;
                    for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                        for (int j = 0; j < abstractBaseBandConfig.getSpectralWindowCount(); ++j) {
                            SPWLabel sPWLabel2 = new SPWLabel(i, j, abstractBaseBandConfig.getBaseBandIndex());
                            int n3 = n2++;
                            String string = hashMap.computeIfAbsent(sPWLabel2, sPWLabel -> String.format("%s-%03d", UUID.randomUUID(), n3));
                            Log.logger(SPWLinker.class).fine("schedBlock=" + schedBlock.getName() + " Tuning=" + i + " baseband=" + abstractBaseBandConfig.getBaseBandName() + " spwIndex=" + j + " UUID=" + string);
                            SpectralWindowI spectralWindowI = abstractBaseBandConfig.getSpectralWindow(j);
                        }
                    }
                }
            }
        }
    }

    class SPWLabel {
        private int tuning;
        private int spwIndex;
        private int basebandIndex;

        public int getTuning() {
            return this.tuning;
        }

        public int getSpwIndex() {
            return this.spwIndex;
        }

        public int getBasebandIndex() {
            return this.basebandIndex;
        }

        public void setTuning(int n) {
            this.tuning = n;
        }

        public void setSpwIndex(int n) {
            this.spwIndex = n;
        }

        public void setBasebandIndex(int n) {
            this.basebandIndex = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SPWLabel)) {
                return false;
            }
            SPWLabel sPWLabel = (SPWLabel)object;
            if (!sPWLabel.canEqual(this)) {
                return false;
            }
            if (this.getTuning() != sPWLabel.getTuning()) {
                return false;
            }
            if (this.getSpwIndex() != sPWLabel.getSpwIndex()) {
                return false;
            }
            return this.getBasebandIndex() == sPWLabel.getBasebandIndex();
        }

        protected boolean canEqual(Object object) {
            return object instanceof SPWLabel;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getTuning();
            n = n * 59 + this.getSpwIndex();
            n = n * 59 + this.getBasebandIndex();
            return n;
        }

        public String toString() {
            return "SPWLinker.SPWLabel(tuning=" + this.getTuning() + ", spwIndex=" + this.getSpwIndex() + ", basebandIndex=" + this.getBasebandIndex() + ")";
        }

        public SPWLabel(int n, int n2, int n3) {
            this.tuning = n;
            this.spwIndex = n2;
            this.basebandIndex = n3;
        }
    }
}

