/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class SpectralLineSBPostProcessor {
    public static final String SINGLE_CONTINUUM_TRANSITION_LABEL = "Single_Continuum";

    private void addRestLinesToSBSpectralWindows(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (scienceGoal.isSpectralScan()) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            int n;
            ArrayList<ExpectedSpectralLine> arrayList = new ArrayList<ExpectedSpectralLine>(Arrays.asList(scienceSpectralWindow.getExpectedSpectralLine()));
            if (arrayList.isEmpty() && scienceSpectralWindow.hasSplatalogId()) {
                n = scienceSpectralWindow.getSplatalogId();
                EventList<alma.obsprep.services.experts.spectralline.SpectralLine> eventList = SpectralLineCatalogue.getInstance(false).getRootCatalogue();
                Optional<alma.obsprep.services.experts.spectralline.SpectralLine> optional = eventList.stream().filter(spectralLine -> spectralLine.getLineId() == n).findFirst();
                optional.ifPresent(spectralLine -> arrayList.add(ExpectedSpectralLine.createNewExpectedLine(spectralLine)));
            }
            n = spectralSetupParameters.isSingleContinuum();
            this.filterOutRestLinesNotInSPWPassbands(schedBlock, n != 0);
            for (ExpectedSpectralLine expectedSpectralLine : arrayList) {
                for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
                    Velocity velocity = spectralSpec.getSourceVelocity();
                    for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                        for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                            FrequencyRange frequencyRange;
                            Frequency frequency;
                            Frequency frequency2 = velocity.reverseShift(spectralWindowI.getEffectiveBandwidth());
                            if (spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_LSB)) {
                                Frequency frequency3 = frequency = n != 0 ? velocity.reverseShift(spectralWindowI.getRestFrequencyLSB()) : spectralWindowI.getRestFrequencyLSB();
                                if (frequency == null) continue;
                                frequencyRange = FrequencyRange.fastCentredOn(frequency, frequency2);
                                if (frequencyRange.contains(expectedSpectralLine.getRestFrequency())) {
                                    Log.logger(SchedBlockPostProcessor.class).fine("Adding " + expectedSpectralLine + " to list of rest lines associated with SPW");
                                    spectralWindowI.addExpectedRestFrequencySpectralLine(expectedSpectralLine, SpectralSpec.SideBand.LSB);
                                }
                            }
                            if (!spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_USB)) continue;
                            Frequency frequency4 = frequency = n != 0 ? velocity.reverseShift(spectralWindowI.getRestFrequencyUSB()) : spectralWindowI.getRestFrequencyUSB();
                            if (frequency == null || !(frequencyRange = FrequencyRange.fastCentredOn(frequency, frequency2)).contains(expectedSpectralLine.getRestFrequency())) continue;
                            Log.logger(SchedBlockPostProcessor.class).fine("Adding " + expectedSpectralLine + " to list of rest lines associated with SPW");
                            spectralWindowI.addExpectedRestFrequencySpectralLine(expectedSpectralLine, SpectralSpec.SideBand.USB);
                        }
                    }
                }
            }
        }
    }

    private void filterOutRestLinesNotInSPWPassbands(@NonNull SchedBlock schedBlock, boolean bl) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                    List list;
                    FrequencyRange frequencyRange;
                    Frequency frequency;
                    Velocity velocity = spectralSpec.getSourceVelocity();
                    Frequency frequency2 = velocity.reverseShift(spectralWindowI.getEffectiveBandwidth());
                    if (spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_LSB)) {
                        frequency = spectralWindowI.getRestFrequencyLSB();
                        if (frequency == null) continue;
                        if (bl) {
                            frequency = velocity.reverseShift(frequency);
                        }
                        frequencyRange = FrequencyRange.fastCentredOn(frequency, frequency2);
                        list = Arrays.stream(spectralWindowI.getLSB().getSpectralLine()).filter(spectralLine -> {
                            Frequency frequency = bl && spectralLine.getTransition().equals(SINGLE_CONTINUUM_TRANSITION_LABEL) ? velocity.reverseShift(spectralLine.getRestFrequency()) : spectralLine.getRestFrequency();
                            return frequencyRange.contains(frequency);
                        }).collect(Collectors.toList());
                        spectralWindowI.clearSpectralLines(SpectralSpec.SideBand.LSB);
                        list.stream().forEach(spectralLine -> spectralWindowI.addSpectralLine(SpectralSpec.SideBand.LSB, (SpectralLine)((Object)spectralLine)));
                    }
                    if (!spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_USB) || (frequency = spectralWindowI.getRestFrequencyUSB()) == null) continue;
                    if (bl) {
                        frequency = velocity.reverseShift(frequency);
                    }
                    frequencyRange = FrequencyRange.fastCentredOn(frequency, frequency2);
                    list = Arrays.stream(spectralWindowI.getUSB().getSpectralLine()).filter(spectralLine -> {
                        Frequency frequency = bl && spectralLine.getTransition().equals(SINGLE_CONTINUUM_TRANSITION_LABEL) ? velocity.reverseShift(spectralLine.getRestFrequency()) : spectralLine.getRestFrequency();
                        return frequencyRange.contains(frequency);
                    }).collect(Collectors.toList());
                    spectralWindowI.clearSpectralLines(SpectralSpec.SideBand.USB);
                    list.stream().forEach(spectralLine -> spectralWindowI.addSpectralLine(SpectralSpec.SideBand.USB, (SpectralLine)((Object)spectralLine)));
                }
            }
        }
    }

    private void transferSingleContinuumRestLineToImageSSW(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        boolean bl;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        boolean bl2 = bl = spectralSetupParameters.isSingleContinuum() && spectralSetupParameters.isWalshSwitching();
        if (!bl) {
            throw new UnsupportedOperationException("isSingleContinuum90DWS called when not a single-continuum 90DSW setup");
        }
        List list = schedBlock.getAllTargets(Optional.empty()).stream().map(Target::getSpectralSpec).filter(spectralSpec -> spectralSpec.getReceiverBand().getNumber() == n).collect(Collectors.toList());
        for (SpectralSpec spectralSpec2 : list) {
            Velocity velocity = spectralSpec2.getSourceVelocity();
            for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec2.getBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                    for (SpectralLine spectralLine : spectralWindowI.getSpectralLines()) {
                        if (!spectralLine.getTransition().equals(SINGLE_CONTINUUM_TRANSITION_LABEL)) continue;
                        Frequency frequency = spectralLine.getRestFrequency();
                        if (!spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_BOTH)) continue;
                        Frequency frequency2 = velocity.reverseShift(spectralWindowI.getEffectiveBandwidth());
                        Frequency frequency3 = velocity.reverseShift(spectralWindowI.getRestFrequencyLSB());
                        boolean bl3 = FrequencyRange.fastCentredOn(frequency3, frequency2).contains(frequency);
                        spectralWindowI.addSpectralLine(bl3 ? SpectralSpec.SideBand.USB : SpectralSpec.SideBand.LSB, spectralLine.transposeLineToImageSSW(velocity, spectralSpec2.getLO1Frequency()));
                    }
                }
            }
        }
    }

    void performRestLinePostProcessing(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        boolean bl;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.addRestLinesToSBSpectralWindows(scienceGoal, schedBlock);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        boolean bl2 = bl = spectralSetupParameters.isSingleContinuum() && spectralSetupParameters.isWalshSwitching();
        if (bl) {
            this.transferSingleContinuumRestLineToImageSSW(scienceGoal, schedBlock);
        }
    }
}

