/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.OUSStructureBuilder;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.SchedBlockConsolidator;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;

public class StandardOUSStructureBuilder
extends OUSStructureBuilder
implements OUSStructureBuilderInterface {
    public StandardOUSStructureBuilder(OUSGenerator oUSGenerator, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        super(oUSGenerator, obsUnitSet, scienceGoal);
    }

    @Override
    public void createOUSStructure(@NonNull SchedBlockPostProcessor schedBlockPostProcessor, @NonNull Collection<ScienceGoal> collection2, Integer n, Boolean bl, Boolean bl2) {
        if (schedBlockPostProcessor == null) {
            throw new NullPointerException("schedBlockPostProcessor is marked non-null but is null");
        }
        if (collection2 == null) {
            throw new NullPointerException("sourceClusteredScienceGoals is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = this.userDefinedScienceGoal.getPerformanceParameters();
        for (int i = 0; i < n; ++i) {
            for (ScienceGoal scienceGoal : collection2) {
                Collection<Collection<SchedBlock>> collection3;
                ObsUnitSet obsUnitSet = this.ousGenerator.getGroupOUS();
                this.rootOUS.addObsUnitSet(obsUnitSet);
                try {
                    collection3 = this.getSchedBlocks(scienceGoal);
                }
                catch (UnknownEntityException | WizardSBGenerationException throwable) {
                    throw new WizardSBGenerationException(throwable);
                }
                for (Collection<SchedBlock> collection4 : collection3) {
                    this.addSBsToOUSes(n, performanceParameters, bl, i, scienceGoal, obsUnitSet, collection4);
                }
                schedBlockPostProcessor.postProcessSBGroup(n, performanceParameters, bl, i, scienceGoal, obsUnitSet, collection3, Optional.empty());
                collection3.stream().forEach(collection -> collection.stream().forEach(SchedBlockConsolidator::consolidate));
            }
            this.setOUSAQUADataProcessingFlags(this.rootOUS);
            try {
                SchedBlockWorker.appendTuningIndicatorToSpectralSpecs(this.rootOUS);
                continue;
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(StandardOUSStructureBuilder.class).warning("Unable to re-label the spectral specs ");
            }
        }
    }
}

