/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockConfiguratorInterface;
import alma.valuetypes.Angle;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.List;
import lombok.NonNull;

class TPSchedBlockRegionalMappingSolarObservingConfigurator
implements SchedBlockConfiguratorInterface {
    @NonNull
    private final SchedBlock sb;
    @NonNull
    private final SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult;

    @Override
    public void configureSB() {
        this.configureOG2ForRegionalMapping();
        this.configureOG3ForRegionalMapping();
        this.configureOG4ForRegionalMapping();
    }

    private void configureOG3ForRegionalMapping() {
        int n = 1;
        @NonNull ObservingGroup observingGroup = this.sb.createObservingGroup();
        observingGroup.setName("Science (regional mapping)");
        @NonNull List<Target> list = this.sb.getObservingGroup(1).getAllOrderedTargets(ScienceParameters.scienceParametersFilter);
        if (list.isEmpty() || list.size() != 1) {
            throw new WizardSBGenerationException("Only 1 solar field source is expected in OG2");
        }
        Target target = Target.duplicateTarget(this.sb, list.get(0), "Ephemeris", "Ephemeris SS", "Science Parameters (regional mapping)");
        FieldSource fieldSource = target.getFieldSource();
        fieldSource.setSolarSystemObject(FieldSource.SOLARSYSTEMOBJECT_EPHEMERIS);
        ScienceGoal scienceGoal = this.sb.getSbGenerationContext().getGoal();
        TargetParameters targetParameters = scienceGoal.getTargetParameters()[0];
        fieldSource.setSourceEphemeris(targetParameters.getSourceEphemeris());
        target.getFirstScienceParameters().ifPresent(scienceParameters -> {
            @NonNull Time time = (Time)this.solarExecutionTimeResult.t_int_EB.minus((AbstractDoubleWithUnit)Time.createTimeSec(400.0));
            scienceParameters.setIntegrationTime(IntTimeSource.of(time));
        });
        this.sb.addTarget(target);
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        orderedTarget.setTarget(target);
        orderedTarget.setIndex(n++);
        observingGroup.addOrderedTarget(orderedTarget);
        this.configureRegionalMappingReferencePosition(target.getFieldSource());
        if (!(fieldSource.getFieldPattern() instanceof FillPattern)) {
            throw new WizardSBGenerationException("Field pattern for TP regional mapping should be a fill pattern");
        }
        FillPattern fillPattern = (FillPattern)((Object)fieldSource.getFieldPattern());
        Angle angle = targetParameters.getSolarMappingDiameter();
        fillPattern.setLatitudeLength(angle.deepCopy());
        fillPattern.setLongitudeLength(angle.deepCopy());
        observingGroup.setMainTarget(target);
    }

    private void configureOG4ForRegionalMapping() {
        int n = 1;
        ObservingGroup observingGroup = this.sb.createObservingGroup();
        observingGroup.setName("Science (full disc)");
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        Target target = this.sb.getScienceTargets().get(0);
        orderedTarget.setTarget(target);
        orderedTarget.setIndex(n++);
        observingGroup.addOrderedTarget(orderedTarget);
        observingGroup.setMainTarget(target);
    }

    private void configureOG2ForRegionalMapping() {
        for (Target target : this.sb.getScienceTargets()) {
            FieldSource fieldSource = target.getFieldSource();
            if (fieldSource.getReferenceCount() != 1) {
                throw new WizardSBGenerationException("There should be a single TP reference position");
            }
            target.getScienceParametersCollection().stream().forEach(scienceParameters -> {
                scienceParameters.setName("Science parameters (full disc)");
                scienceParameters.setIntegrationTime(IntTimeSource.of(Time.createTimeSec(200.0)));
            });
            this.configureRegionalMappingReferencePosition(fieldSource);
        }
        this.sb.getObservingGroup(1).setName("Science (full disc)");
    }

    private void setReferencePositionTimingParameters(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("referencePosition is marked non-null but is null");
        }
        reference.setIntegrationTime(Time.createTimeSec(10.0));
        reference.setSubScanDuration(Time.createTimeSec(9.216));
    }

    private void configureRegionalMappingReferencePosition(@NonNull FieldSource fieldSource) {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        Reference reference = fieldSource.getReference(0);
        this.setReferencePositionTimingParameters(reference);
        SkyCoordinates skyCoordinates = reference.getReferenceCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        skyCoordinates.setLongitude(Longitude.createLongitude((double)2.0, (String)Longitude.UNIT_DEG));
    }

    public TPSchedBlockRegionalMappingSolarObservingConfigurator(@NonNull SchedBlock schedBlock, @NonNull SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (solarExecutionTimeResult == null) {
            throw new NullPointerException("solarExecutionTimeResult is marked non-null but is null");
        }
        this.sb = schedBlock;
        this.solarExecutionTimeResult = solarExecutionTimeResult;
    }
}

