/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import lombok.NonNull;
import org.apache.commons.math3.util.ArithmeticUtils;

public class TPReferencePositionWorker {
    public static void setupReferencePosition(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (!target.hasAmplitudeCalParameters() && !target.hasScienceParameters()) {
            throw new WizardSBGenerationException("Only ampcals and science targets may have a reference position attached.");
        }
        FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
        for (Reference reference : target.getFieldSource().getReference()) {
            Object object;
            Object object2;
            Object object3;
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
            Double d = null;
            if (fieldPattern instanceof RectanglePattern) {
                object3 = (RectanglePattern)((Object)fieldPattern);
                d = object3.getLatitudeLength().isGreaterThan((AbstractDoubleWithUnit)object3.getLongitudeLength()) ? Double.valueOf(object3.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC)) : Double.valueOf(object3.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC));
            } else if (fieldPattern instanceof PointingPattern) {
                object3 = target.getFieldSource().getTargetParameters();
                if (object3 == null) {
                    throw new WizardSBGenerationException("Unable to determine target parameters associated with field source " + target.getFieldSource().getName());
                }
                object2 = null;
                try {
                    object2 = MinBoundingBoxExpert.getBoundingRectangle((TargetParameters)object3).getTPArrayRectangle(spectralSpec);
                    Log.logger(TPReferencePositionWorker.class).fine("TP bounding rectangle dimensions (arcsec) are : Long " + ((Rectangle)object2).getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC) + " Short " + ((Rectangle)object2).getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.logger(SpectralSpecFactory.class).warning("Unable to determine minimum bounding box around pointings: " + illegalArgumentException.getMessage());
                    throw new WizardSBGenerationException(illegalArgumentException);
                }
                assert (object2 != null);
                d = ((Rectangle)object2).getLatitudeLength().isGreaterThan(((Rectangle)object2).getLongitudeLength()) ? Double.valueOf(((Rectangle)object2).getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC)) : Double.valueOf(((Rectangle)object2).getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC));
            } else if (fieldPattern instanceof FillPattern) {
                d = Longitude.createLongitude((double)2.0, (String)Longitude.UNIT_DEG).getContentInUnits(Longitude.UNIT_ARCSEC);
            } else {
                throw new WizardSBGenerationException("Unable to handle this pointing pattern type when setting up the TP reference position");
            }
            assert (d != null);
            skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Longitude.UNIT_ARCSEC));
            reference.setReferenceCoordinates(skyCoordinates);
            object3 = TPReferencePositionWorker.getFieldReferenceIntegrationTime(target, d);
            reference.setIntegrationTime((Time)object3);
            if (target.hasAmplitudeCalParameters()) {
                object = target.getAmplitudeCalParametersList()[0];
                object2 = (Time)object.getSubScanDuration().multiply(0.95);
            } else if (target.hasScienceParameters()) {
                object = target.getScienceParametersList()[0];
                object2 = (Time)object.getSubScanDuration().multiply(0.95);
            } else {
                throw new WizardSBGenerationException("Unable to determine reference cycle time for any other target type but science and amp cal");
            }
            reference.setCycleTime((Time)object2);
            double d2 = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            double d3 = ((Time)object3).getContentInUnits(Time.UNIT_MS);
            long l = ArithmeticUtils.lcm((long)((long)d2), (long)48L);
            double d4 = Math.ceil(d3 / (double)l) * (double)l;
            Time time = Time.createTime((double)(d4 / 1000.0), (String)Time.UNIT_S);
            reference.setSubScanDuration(time);
        }
    }

    private static Time getFieldReferenceIntegrationTime(@NonNull Target target, double d) {
        double d2;
        Object object;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        SpectralSpec spectralSpec = target.getSpectralSpec();
        if (target.hasAmplitudeCalParameters()) {
            object = target.getAmplitudeCalParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else if (target.hasScienceParameters()) {
            object = target.getScienceParametersList()[0];
            d2 = object.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        } else {
            throw new WizardSBGenerationException("Unable to determine t_sub for any other target but science and amp cal");
        }
        try {
            object = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(6.3, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, (Frequency)((Object)object));
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        double d3 = userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC) * 1.0;
        double d4 = Math.sqrt(1.0 * (d2 + 1.0) * (d3 * d2 / d / 5.0));
        return Time.createTimeSec(d4);
    }
}

