/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.util.List;

public class DGCB2BFrequencySetup {
    private FrequencyRange lo1Range;
    private List<Frequency> spwCentres;
    private HarmonicEnum frequencySwitchingMode;
    private ReceiverBand scienceReceiverBand;
    private ReceiverBand referenceReceiverBand;
    private Frequency singleContinuumFrequency;
    Time phaseCycleTime;
    private Time phaseIntTime;
    private Time checkSourceIntTime;
    private Time dgcScienceCalIntegrationTime;
    private Time dgcRefCalIntegrationTime;
    private int internalCycleCount;

    private static Time $default$phaseCycleTime() {
        return null;
    }

    private static Time $default$phaseIntTime() {
        return null;
    }

    private static Time $default$checkSourceIntTime() {
        return null;
    }

    private static Time $default$dgcScienceCalIntegrationTime() {
        return null;
    }

    private static Time $default$dgcRefCalIntegrationTime() {
        return null;
    }

    DGCB2BFrequencySetup(FrequencyRange frequencyRange, List<Frequency> list, HarmonicEnum harmonicEnum, ReceiverBand receiverBand, ReceiverBand receiverBand2, Frequency frequency, Time time, Time time2, Time time3, Time time4, Time time5, int n) {
        this.lo1Range = frequencyRange;
        this.spwCentres = list;
        this.frequencySwitchingMode = harmonicEnum;
        this.scienceReceiverBand = receiverBand;
        this.referenceReceiverBand = receiverBand2;
        this.singleContinuumFrequency = frequency;
        this.phaseCycleTime = time;
        this.phaseIntTime = time2;
        this.checkSourceIntTime = time3;
        this.dgcScienceCalIntegrationTime = time4;
        this.dgcRefCalIntegrationTime = time5;
        this.internalCycleCount = n;
    }

    public static DGCB2BFrequencySetupBuilder builder() {
        return new DGCB2BFrequencySetupBuilder();
    }

    public FrequencyRange getLo1Range() {
        return this.lo1Range;
    }

    public List<Frequency> getSpwCentres() {
        return this.spwCentres;
    }

    public HarmonicEnum getFrequencySwitchingMode() {
        return this.frequencySwitchingMode;
    }

    public ReceiverBand getScienceReceiverBand() {
        return this.scienceReceiverBand;
    }

    public ReceiverBand getReferenceReceiverBand() {
        return this.referenceReceiverBand;
    }

    public Frequency getSingleContinuumFrequency() {
        return this.singleContinuumFrequency;
    }

    public Time getPhaseCycleTime() {
        return this.phaseCycleTime;
    }

    public Time getPhaseIntTime() {
        return this.phaseIntTime;
    }

    public Time getCheckSourceIntTime() {
        return this.checkSourceIntTime;
    }

    public Time getDgcScienceCalIntegrationTime() {
        return this.dgcScienceCalIntegrationTime;
    }

    public Time getDgcRefCalIntegrationTime() {
        return this.dgcRefCalIntegrationTime;
    }

    public int getInternalCycleCount() {
        return this.internalCycleCount;
    }

    public void setLo1Range(FrequencyRange frequencyRange) {
        this.lo1Range = frequencyRange;
    }

    public void setSpwCentres(List<Frequency> list) {
        this.spwCentres = list;
    }

    public void setFrequencySwitchingMode(HarmonicEnum harmonicEnum) {
        this.frequencySwitchingMode = harmonicEnum;
    }

    public void setScienceReceiverBand(ReceiverBand receiverBand) {
        this.scienceReceiverBand = receiverBand;
    }

    public void setReferenceReceiverBand(ReceiverBand receiverBand) {
        this.referenceReceiverBand = receiverBand;
    }

    public void setSingleContinuumFrequency(Frequency frequency) {
        this.singleContinuumFrequency = frequency;
    }

    public void setPhaseCycleTime(Time time) {
        this.phaseCycleTime = time;
    }

    public void setPhaseIntTime(Time time) {
        this.phaseIntTime = time;
    }

    public void setCheckSourceIntTime(Time time) {
        this.checkSourceIntTime = time;
    }

    public void setDgcScienceCalIntegrationTime(Time time) {
        this.dgcScienceCalIntegrationTime = time;
    }

    public void setDgcRefCalIntegrationTime(Time time) {
        this.dgcRefCalIntegrationTime = time;
    }

    public void setInternalCycleCount(int n) {
        this.internalCycleCount = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DGCB2BFrequencySetup)) {
            return false;
        }
        DGCB2BFrequencySetup dGCB2BFrequencySetup = (DGCB2BFrequencySetup)object;
        if (!dGCB2BFrequencySetup.canEqual(this)) {
            return false;
        }
        if (this.getInternalCycleCount() != dGCB2BFrequencySetup.getInternalCycleCount()) {
            return false;
        }
        FrequencyRange frequencyRange = this.getLo1Range();
        FrequencyRange frequencyRange2 = dGCB2BFrequencySetup.getLo1Range();
        if (frequencyRange == null ? frequencyRange2 != null : !frequencyRange.equals(frequencyRange2)) {
            return false;
        }
        List<Frequency> list = this.getSpwCentres();
        List<Frequency> list2 = dGCB2BFrequencySetup.getSpwCentres();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        HarmonicEnum harmonicEnum = this.getFrequencySwitchingMode();
        HarmonicEnum harmonicEnum2 = dGCB2BFrequencySetup.getFrequencySwitchingMode();
        if (harmonicEnum == null ? harmonicEnum2 != null : !((Object)((Object)harmonicEnum)).equals((Object)harmonicEnum2)) {
            return false;
        }
        ReceiverBand receiverBand = this.getScienceReceiverBand();
        ReceiverBand receiverBand2 = dGCB2BFrequencySetup.getScienceReceiverBand();
        if (receiverBand == null ? receiverBand2 != null : !receiverBand.equals(receiverBand2)) {
            return false;
        }
        ReceiverBand receiverBand3 = this.getReferenceReceiverBand();
        ReceiverBand receiverBand4 = dGCB2BFrequencySetup.getReferenceReceiverBand();
        if (receiverBand3 == null ? receiverBand4 != null : !receiverBand3.equals(receiverBand4)) {
            return false;
        }
        Frequency frequency = this.getSingleContinuumFrequency();
        Frequency frequency2 = dGCB2BFrequencySetup.getSingleContinuumFrequency();
        if (frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2)) {
            return false;
        }
        Time time = this.getPhaseCycleTime();
        Time time2 = dGCB2BFrequencySetup.getPhaseCycleTime();
        if (time == null ? time2 != null : !time.equals(time2)) {
            return false;
        }
        Time time3 = this.getPhaseIntTime();
        Time time4 = dGCB2BFrequencySetup.getPhaseIntTime();
        if (time3 == null ? time4 != null : !time3.equals(time4)) {
            return false;
        }
        Time time5 = this.getCheckSourceIntTime();
        Time time6 = dGCB2BFrequencySetup.getCheckSourceIntTime();
        if (time5 == null ? time6 != null : !time5.equals(time6)) {
            return false;
        }
        Time time7 = this.getDgcScienceCalIntegrationTime();
        Time time8 = dGCB2BFrequencySetup.getDgcScienceCalIntegrationTime();
        if (time7 == null ? time8 != null : !time7.equals(time8)) {
            return false;
        }
        Time time9 = this.getDgcRefCalIntegrationTime();
        Time time10 = dGCB2BFrequencySetup.getDgcRefCalIntegrationTime();
        return !(time9 == null ? time10 != null : !time9.equals(time10));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DGCB2BFrequencySetup;
    }

    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getInternalCycleCount();
        FrequencyRange frequencyRange = this.getLo1Range();
        n = n * 59 + (frequencyRange == null ? 43 : frequencyRange.hashCode());
        List<Frequency> list = this.getSpwCentres();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        HarmonicEnum harmonicEnum = this.getFrequencySwitchingMode();
        n = n * 59 + (harmonicEnum == null ? 43 : ((Object)((Object)harmonicEnum)).hashCode());
        ReceiverBand receiverBand = this.getScienceReceiverBand();
        n = n * 59 + (receiverBand == null ? 43 : receiverBand.hashCode());
        ReceiverBand receiverBand2 = this.getReferenceReceiverBand();
        n = n * 59 + (receiverBand2 == null ? 43 : receiverBand2.hashCode());
        Frequency frequency = this.getSingleContinuumFrequency();
        n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
        Time time = this.getPhaseCycleTime();
        n = n * 59 + (time == null ? 43 : time.hashCode());
        Time time2 = this.getPhaseIntTime();
        n = n * 59 + (time2 == null ? 43 : time2.hashCode());
        Time time3 = this.getCheckSourceIntTime();
        n = n * 59 + (time3 == null ? 43 : time3.hashCode());
        Time time4 = this.getDgcScienceCalIntegrationTime();
        n = n * 59 + (time4 == null ? 43 : time4.hashCode());
        Time time5 = this.getDgcRefCalIntegrationTime();
        n = n * 59 + (time5 == null ? 43 : time5.hashCode());
        return n;
    }

    public String toString() {
        return "DGCB2BFrequencySetup(lo1Range=" + this.getLo1Range() + ", spwCentres=" + this.getSpwCentres() + ", frequencySwitchingMode=" + this.getFrequencySwitchingMode() + ", scienceReceiverBand=" + this.getScienceReceiverBand() + ", referenceReceiverBand=" + this.getReferenceReceiverBand() + ", singleContinuumFrequency=" + this.getSingleContinuumFrequency() + ", phaseCycleTime=" + this.getPhaseCycleTime() + ", phaseIntTime=" + this.getPhaseIntTime() + ", checkSourceIntTime=" + this.getCheckSourceIntTime() + ", dgcScienceCalIntegrationTime=" + this.getDgcScienceCalIntegrationTime() + ", dgcRefCalIntegrationTime=" + this.getDgcRefCalIntegrationTime() + ", internalCycleCount=" + this.getInternalCycleCount() + ")";
    }

    public static class DGCB2BFrequencySetupBuilder {
        private FrequencyRange lo1Range;
        private List<Frequency> spwCentres;
        private HarmonicEnum frequencySwitchingMode;
        private ReceiverBand scienceReceiverBand;
        private ReceiverBand referenceReceiverBand;
        private Frequency singleContinuumFrequency;
        private boolean phaseCycleTime$set;
        private Time phaseCycleTime$value;
        private boolean phaseIntTime$set;
        private Time phaseIntTime$value;
        private boolean checkSourceIntTime$set;
        private Time checkSourceIntTime$value;
        private boolean dgcScienceCalIntegrationTime$set;
        private Time dgcScienceCalIntegrationTime$value;
        private boolean dgcRefCalIntegrationTime$set;
        private Time dgcRefCalIntegrationTime$value;
        private int internalCycleCount;

        DGCB2BFrequencySetupBuilder() {
        }

        public DGCB2BFrequencySetupBuilder lo1Range(FrequencyRange frequencyRange) {
            this.lo1Range = frequencyRange;
            return this;
        }

        public DGCB2BFrequencySetupBuilder spwCentres(List<Frequency> list) {
            this.spwCentres = list;
            return this;
        }

        public DGCB2BFrequencySetupBuilder frequencySwitchingMode(HarmonicEnum harmonicEnum) {
            this.frequencySwitchingMode = harmonicEnum;
            return this;
        }

        public DGCB2BFrequencySetupBuilder scienceReceiverBand(ReceiverBand receiverBand) {
            this.scienceReceiverBand = receiverBand;
            return this;
        }

        public DGCB2BFrequencySetupBuilder referenceReceiverBand(ReceiverBand receiverBand) {
            this.referenceReceiverBand = receiverBand;
            return this;
        }

        public DGCB2BFrequencySetupBuilder singleContinuumFrequency(Frequency frequency) {
            this.singleContinuumFrequency = frequency;
            return this;
        }

        public DGCB2BFrequencySetupBuilder phaseCycleTime(Time time) {
            this.phaseCycleTime$value = time;
            this.phaseCycleTime$set = true;
            return this;
        }

        public DGCB2BFrequencySetupBuilder phaseIntTime(Time time) {
            this.phaseIntTime$value = time;
            this.phaseIntTime$set = true;
            return this;
        }

        public DGCB2BFrequencySetupBuilder checkSourceIntTime(Time time) {
            this.checkSourceIntTime$value = time;
            this.checkSourceIntTime$set = true;
            return this;
        }

        public DGCB2BFrequencySetupBuilder dgcScienceCalIntegrationTime(Time time) {
            this.dgcScienceCalIntegrationTime$value = time;
            this.dgcScienceCalIntegrationTime$set = true;
            return this;
        }

        public DGCB2BFrequencySetupBuilder dgcRefCalIntegrationTime(Time time) {
            this.dgcRefCalIntegrationTime$value = time;
            this.dgcRefCalIntegrationTime$set = true;
            return this;
        }

        public DGCB2BFrequencySetupBuilder internalCycleCount(int n) {
            this.internalCycleCount = n;
            return this;
        }

        public DGCB2BFrequencySetup build() {
            Time time = this.phaseCycleTime$value;
            if (!this.phaseCycleTime$set) {
                time = DGCB2BFrequencySetup.$default$phaseCycleTime();
            }
            Time time2 = this.phaseIntTime$value;
            if (!this.phaseIntTime$set) {
                time2 = DGCB2BFrequencySetup.$default$phaseIntTime();
            }
            Time time3 = this.checkSourceIntTime$value;
            if (!this.checkSourceIntTime$set) {
                time3 = DGCB2BFrequencySetup.$default$checkSourceIntTime();
            }
            Time time4 = this.dgcScienceCalIntegrationTime$value;
            if (!this.dgcScienceCalIntegrationTime$set) {
                time4 = DGCB2BFrequencySetup.$default$dgcScienceCalIntegrationTime();
            }
            Time time5 = this.dgcRefCalIntegrationTime$value;
            if (!this.dgcRefCalIntegrationTime$set) {
                time5 = DGCB2BFrequencySetup.$default$dgcRefCalIntegrationTime();
            }
            return new DGCB2BFrequencySetup(this.lo1Range, this.spwCentres, this.frequencySwitchingMode, this.scienceReceiverBand, this.referenceReceiverBand, this.singleContinuumFrequency, time, time2, time3, time4, time5, this.internalCycleCount);
        }

        public String toString() {
            return "DGCB2BFrequencySetup.DGCB2BFrequencySetupBuilder(lo1Range=" + this.lo1Range + ", spwCentres=" + this.spwCentres + ", frequencySwitchingMode=" + this.frequencySwitchingMode + ", scienceReceiverBand=" + this.scienceReceiverBand + ", referenceReceiverBand=" + this.referenceReceiverBand + ", singleContinuumFrequency=" + this.singleContinuumFrequency + ", phaseCycleTime$value=" + this.phaseCycleTime$value + ", phaseIntTime$value=" + this.phaseIntTime$value + ", checkSourceIntTime$value=" + this.checkSourceIntTime$value + ", dgcScienceCalIntegrationTime$value=" + this.dgcScienceCalIntegrationTime$value + ", dgcRefCalIntegrationTime$value=" + this.dgcRefCalIntegrationTime$value + ", internalCycleCount=" + this.internalCycleCount + ")";
        }
    }

    public static enum HarmonicEnum {
        HARMONIC,
        NONHARMONIC;

    }
}

