/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BFrequencySetup;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BReferenceSpectralSpecBuilderBase;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import alma.valuetypes.Frequency;
import java.util.HashMap;

class SpectralSpecMap
extends HashMap<String, SpectralSpec> {
    private final SpectralSpecWorker spectralSpecWorker;
    private transient SpectralSpec scienceSpectralSpec = null;
    private final SBGenerationContext sbContext;

    @Override
    public SpectralSpec get(Object object) {
        SpectralSpec spectralSpec = null;
        if (this.containsKey(object)) {
            spectralSpec = (SpectralSpec)super.get(object);
        } else {
            switch ((String)object) {
                case "DGC_B2B": {
                    SpectralSpec spectralSpec2 = this.spectralSpecWorker.getDGCRefB2BSpectralSpec(this.scienceSpectralSpec);
                    this.put("DGC_B2B", spectralSpec2);
                    spectralSpec = spectralSpec2;
                    break;
                }
                case "DGC_BWSW": {
                    SpectralSpec spectralSpec3 = this.spectralSpecWorker.getDGCRefBWSWSpectralSpec(this.scienceSpectralSpec);
                    this.put("DGC_BWSW", spectralSpec3);
                    spectralSpec = spectralSpec3;
                    break;
                }
                case "TDMPhase": {
                    SpectralSpec spectralSpec4 = this.spectralSpecWorker.getTDMPhaseSpectralSpec(this.scienceSpectralSpec);
                    this.put("TDMPhase", spectralSpec4);
                    spectralSpec = spectralSpec4;
                    break;
                }
                case "POINTING": {
                    spectralSpec = this.createPointingSpec();
                    break;
                }
                case "FOCUS": {
                    spectralSpec = this.createFocusSpectralSpec();
                    break;
                }
                case "DELAY": {
                    spectralSpec = this.createDelaySpectralSpec();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown key provided for spectral spec map: " + object);
                }
            }
        }
        return spectralSpec;
    }

    private SpectralSpec createDelaySpectralSpec() {
        SpectralSpec spectralSpec = this.spectralSpecWorker.createSpectralSpecWithCorrelatorConfiguration();
        this.spectralSpecWorker.setupScienceSpectralSpec(spectralSpec, this.spectralSpecWorker.ssp, false);
        if (this.spectralSpecWorker.sbContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL)) {
            spectralSpec = SpectralSpecFactory.convertToTopo(spectralSpec);
        }
        spectralSpec.setName("Delay Setup");
        this.put("DELAY", spectralSpec);
        return spectralSpec;
    }

    private SpectralSpec createFocusSpectralSpec() {
        SpectralSpec spectralSpec = null;
        SpectralSpec spectralSpec2 = this.spectralSpecWorker.createSpectralSpecWithCorrelatorConfiguration();
        spectralSpec2.setSourceVelocity(this.spectralSpecWorker.velocity.deepCopy());
        int n = this.scienceSpectralSpec.getReceiverBand().getNumber();
        if (n == 8) {
            this.spectralSpecWorker.setupContinuumSpectralSpec(spectralSpec2, Frequency.createFrequencyGHZ(410.5), "Focus");
            this.put("FOCUS", spectralSpec2);
            spectralSpec = spectralSpec2;
        } else if (n == 7) {
            this.spectralSpecWorker.setupContinuumSpectralSpec(spectralSpec2, Frequency.createFrequencyGHZ(290.0), "Focus");
            this.put("FOCUS", spectralSpec2);
            spectralSpec = spectralSpec2;
        }
        return spectralSpec;
    }

    private SpectralSpec createPointingSpec() {
        Object object;
        int n = this.scienceSpectralSpec.getReceiverBand().getNumber();
        if (DGCExpert.getExpert().isB2BScheduled(this.sbContext.getGoal(), true).isB2BCompliant()) {
            object = DGCB2BReferenceSpectralSpecBuilderBase.lookUpDGCB2BRefData(this.scienceSpectralSpec.getReceiverBand(), this.scienceSpectralSpec.getLO1Frequency());
            n = ((DGCB2BFrequencySetup)object).getReferenceReceiverBand().getNumber();
        }
        object = this.spectralSpecWorker.createSpectralSpecWithCorrelatorConfiguration();
        ((SpectralSpec)object).setSourceVelocity(this.spectralSpecWorker.velocity.deepCopy());
        switch (n) {
            case 1: 
            case 3: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(103.0), "Pointing");
                break;
            }
            case 4: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(155.0), "Pointing");
                break;
            }
            case 5: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(203.0), "Pointing");
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(290.0), "Pointing");
                break;
            }
            case 8: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(410.5), "Pointing");
                break;
            }
            default: {
                this.spectralSpecWorker.setupContinuumSpectralSpec((SpectralSpec)object, Frequency.createFrequencyGHZ(223.25), "Pointing");
            }
        }
        this.put("POINTING", object);
        return object;
    }

    public SpectralSpecMap(SpectralSpecWorker spectralSpecWorker, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        this.spectralSpecWorker = spectralSpecWorker;
        this.scienceSpectralSpec = spectralSpec;
        this.sbContext = sBGenerationContext;
    }
}

