/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

final class FieldSourceWorkerUtils {
    private static final Collection<String> RASTER_TYPES = Collections.unmodifiableCollection(List.of(FieldPattern.TYPE_RECTANGLE));

    public static Reference getAtmosphericReferencePosition(@NonNull SpectralSpec spectralSpec, @NonNull FieldSource fieldSource) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        Reference reference = Reference.createReference();
        reference.setCycleTime(Time.createTime((double)100.0, (String)Time.UNIT_H));
        reference.setIntegrationTime(Time.createTimeSec(4.0));
        SkyCoordinates skyCoordinates = FieldSourceWorkerUtils.getReferencePosition(fieldSource);
        reference.setReferenceCoordinates(skyCoordinates);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        Time time = abstractCorrelatorConfiguration.getIntegrationDuration();
        CorrelatorExpert correlatorExpert = spectralSpec.getCorrelatorExpert();
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = correlatorExpert.calcSubscanDuration(2.0, d, null);
        reference.setSubScanDuration(Time.createTimeSec(d2));
        return reference;
    }

    private static SkyCoordinates getReferencePosition(@NonNull FieldSource fieldSource) {
        if (fieldSource == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        if (RASTER_TYPES.contains(fieldSource.getFieldPatternType())) {
            return FieldSourceWorkerUtils.getRasterReferencePosition(fieldSource);
        }
        return FieldSourceWorkerUtils.getDefaultReferencePosition();
    }

    private static SkyCoordinates getRasterReferencePosition(@NonNull FieldSource fieldSource) {
        if (fieldSource == null) {
            throw new NullPointerException("fs is marked non-null but is null");
        }
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        Angle angle = rectanglePattern.getLatitudeLength().deepCopy();
        Longitude longitude = Longitude.createLongitude((double)angle.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
        skyCoordinates.setLongitude(longitude);
        return skyCoordinates;
    }

    private static SkyCoordinates getDefaultReferencePosition() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_HORIZON);
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Angle.UNIT_ARCMIN));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)2.0, (String)Angle.UNIT_ARCMIN));
        return skyCoordinates;
    }

    private FieldSourceWorkerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

