/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network.versioncheck;

import alma.obsprep.services.network.versioncheck.UpdateStatus;
import alma.obsprep.services.network.versioncheck.VersionChecker;
import alma.obsprep.services.network.versioncheck.ws.Status;
import alma.obsprep.services.network.versioncheck.ws.VersionCheck;
import alma.obsprep.services.network.versioncheck.ws.VersionCheckResult;
import alma.obsprep.services.network.versioncheck.ws.VersionCheckService;
import com.sun.xml.ws.client.ClientTransportException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;

public class WebServiceVersionChecker
implements VersionChecker {
    private final VersionCheckService service;
    private static int REQUEST_TIMEOUT = 4000;
    private static int CONNECT_TIMEOUT = 4000;

    public WebServiceVersionChecker() throws MalformedURLException, IOException {
        this(null);
    }

    public void setRequestTimeout(int n) {
        REQUEST_TIMEOUT = n;
    }

    public void setConnectTimeout(int n) {
        CONNECT_TIMEOUT = n;
    }

    public WebServiceVersionChecker(URL uRL) throws IOException {
        if (uRL == null) {
            try {
                uRL = new URL("https://asa.alma.cl/submissionservice/VersionCheck");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        uRL = new URL(null, uRL.toString(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL uRL) throws IOException {
                URL uRL2 = new URL(uRL.toString());
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                httpURLConnection.setConnectTimeout(CONNECT_TIMEOUT);
                httpURLConnection.setReadTimeout(REQUEST_TIMEOUT);
                return httpURLConnection;
            }
        });
        WebServiceClient webServiceClient = VersionCheckService.class.getAnnotation(WebServiceClient.class);
        QName qName = new QName(webServiceClient.targetNamespace(), webServiceClient.name());
        try {
            this.service = new VersionCheckService(uRL, qName);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("No web service found at " + uRL.toString(), runtimeException);
        }
    }

    @Override
    public alma.obsprep.services.network.versioncheck.VersionCheckResult check(String string) throws IOException {
        try {
            VersionCheck versionCheck = this.service.getVersionCheckPort();
            this.setPortTimeout(versionCheck);
            VersionCheckResult versionCheckResult = versionCheck.check(string);
            return this.toPojo(versionCheckResult);
        }
        catch (ClientTransportException clientTransportException) {
            throw new IOException(clientTransportException.getCause());
        }
        catch (WebServiceException webServiceException) {
            if (webServiceException.getCause() instanceof SocketTimeoutException) {
                throw new IOException(webServiceException.getCause());
            }
            throw webServiceException;
        }
    }

    private alma.obsprep.services.network.versioncheck.VersionCheckResult toPojo(VersionCheckResult versionCheckResult) {
        Status status = versionCheckResult.getStatus();
        UpdateStatus updateStatus = UpdateStatus.toPojo(status);
        String string = versionCheckResult.getUpdateUrl();
        return new alma.obsprep.services.network.versioncheck.VersionCheckResult(updateStatus, string);
    }

    private void setPortTimeout(VersionCheck versionCheck) {
        Map map = ((BindingProvider)versionCheck).getRequestContext();
        map.put("com.sun.xml.ws.connect.timeout", CONNECT_TIMEOUT);
        map.put("com.sun.xml.ws.request.timeout", REQUEST_TIMEOUT);
    }
}

