/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTJTextArea;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.services.summaryfeedback.AngularResolutionRenderer;
import alma.obsprep.services.summaryfeedback.PIContactInfo;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.PreviousProposalInfo;
import alma.obsprep.services.summaryfeedback.ProposalCoverSheetExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryModel;
import alma.obsprep.services.summaryfeedback.ProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalInfo;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class ProposalSummaryView
extends SummaryFeedbackView {
    private static final long serialVersionUID = -2539061984856394740L;
    public static final FieldID TITLEPANEL = new FieldID("ProposalSummary.titlePanel");
    public static final FieldID ASTRONCATEG = new FieldID("ProposalSummary.astroCateg");
    public static final FieldID PINAME = new FieldID("ProposalSummary.title");
    public static final FieldID PIEMAIL = new FieldID("ProposalSummary.PIEmail");
    public static final FieldID PIINSTITUTE = new FieldID("ProposalSummary.PIInstitute");
    public static final FieldID TOTAL12MTIME = new FieldID("ProposalSummary.total12mTime");
    public static final FieldID TOTAL7MTIME = new FieldID("ProposalSummary.totalOtherTime");
    public static final FieldID TOTALTPTIME = new FieldID("ProposalSummary.tpTime");
    public static final FieldID COPINAMES = new FieldID("ProposalSummary.CoPINames");
    public static final FieldID COINAMES = new FieldID("ProposalSummary.CiINames");
    public static final FieldID ABSTRACT = new FieldID("ProposalSummary.abstract");
    public static final FieldID SGINFO = new FieldID("ProposalSummary.sgInfo");
    public static final FieldID DUPLICATEOBSERVATION = new FieldID("ProposalSummary.duplicateInfo");
    public static final FieldID TIMECONSTRAINTS = new FieldID("ProposalSummary.timeConstraints");
    public static final FieldID EXTRATIME = new FieldID("ProposalSummary.extraTime");
    public static final FieldID PICONTACTINFO = new FieldID("ProposalSummary.PIContactInfo");
    public static final int MAX_SGS = 30;
    private static final int MAX_TITLE_LENGTH = 120;
    private static final int MAX_TITLE_FIELD_COLS = 40;
    protected JPanel headerPanel;
    protected JPanel mainPanel;

    @Override
    protected void addComponentArray(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ComponentCollection componentCollection) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        int n = componentCollection.getComponents().size();
        JComponent[] jComponentArray = componentCollection.getComponents().toArray(new JComponent[n]);
        Integer[] integerArray = componentCollection.getWidths().toArray(new Integer[n]);
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridwidth = integerArray[i];
            gridBagLayout.setConstraints(jComponentArray[i], gridBagConstraints);
            jComponent.add(jComponentArray[i]);
            gridBagConstraints.gridx += integerArray[i].intValue();
        }
        gridBagConstraints.gridwidth = 1;
    }

    public ProposalSummaryView(Model model) {
        super(model);
    }

    @Override
    protected ProposalSummaryView createOffView() {
        ProposalSummaryView proposalSummaryView = new ProposalSummaryView(this.getModel());
        proposalSummaryView.setBackgroundToWhite();
        return proposalSummaryView;
    }

    @Override
    public ProposalSummaryModel getModel() {
        return (ProposalSummaryModel)super.getModel();
    }

    @Override
    protected void build() {
        super.build("NewProposalSummaryView");
    }

    @Override
    protected void addComponents(String string) {
        this.headerPanel = this.createHeaderPanel();
        this.addComponent(this.headerPanel);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.mainPanel = this.createMainPanel();
        this.addComponent(this.mainPanel);
    }

    private Border createBorder() {
        return BorderFactory.createLineBorder(Color.BLACK);
    }

    private LabelBuilder makeLabel() {
        return new LabelBuilder();
    }

    private LabelBuilder makeFixedLabel(String string) {
        return this.makeLabel().setFixed().setTextTo(string).setCenter();
    }

    private LabelBuilder makeItemLabel(FieldID fieldID) {
        return this.makeLabel().setFieldIDTo(fieldID).setCenter();
    }

    protected JTextArea makeTextArea(int n, int n2) {
        OTJTextArea oTJTextArea = new OTJTextArea();
        oTJTextArea.setRows(n);
        oTJTextArea.setColumns(n2);
        oTJTextArea.setLineWrap(true);
        oTJTextArea.setWrapStyleWord(true);
        oTJTextArea.setEditable(false);
        oTJTextArea.setOpaque(false);
        oTJTextArea.setMargin(new Insets(0, 10, 0, 50));
        return oTJTextArea;
    }

    @Override
    protected JTextArea makeTextArea(FieldID fieldID, int n, int n2) {
        JTextArea jTextArea = this.makeTextArea(n, n2);
        this.register(jTextArea, fieldID);
        return jTextArea;
    }

    protected JPanel makeWrappedTextArea(FieldID fieldID, int n, int n2) {
        return this.wrapTextArea(this.makeTextArea(fieldID, n, n2));
    }

    protected JPanel wrapTextArea(JTextArea jTextArea) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(this.createBorder());
        jPanel.add(jTextArea);
        return jPanel;
    }

    protected JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(gridBagLayout);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new BannerPanel(TITLEPANEL));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.defaultBackgroundColor = jPanel.getBackground();
        jPanel.setLayout(gridBagLayout);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeFixedLabel("ABSTRACT").setCenter());
        JPanel jPanel2 = this.makeWrappedTextArea(ABSTRACT, 12, 70);
        this.getComponent(ABSTRACT);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember((JComponent)this.makeFixedLabel("SCIENCE CATEGORY:"), 1);
        componentCollection.remember((JComponent)this.makeWrappedTextArea(ASTRONCATEG, 2, 1), 10);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember((JComponent)this.makeFixedLabel("<html><center>ESTIMATED</center><center>12-M TIME:</center></html>"), 2);
        componentCollection.remember((JComponent)this.makeItemLabel(TOTAL12MTIME).setBoldFont(), 1);
        componentCollection.remember((JComponent)this.makeFixedLabel("<html><center>ESTIMATED</center><center>7-M TIME:</center></html>"), 2);
        componentCollection.remember((JComponent)this.makeItemLabel(TOTAL7MTIME).setBoldFont(), 1);
        componentCollection.remember((JComponent)this.makeFixedLabel("<html><center>ESTIMATED </center><center>TP TIME:</center></html>"), 4);
        componentCollection.remember((JComponent)this.makeItemLabel(TOTALTPTIME).setBoldFont(), 1);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection = new ComponentCollection();
        componentCollection.remember((JComponent)this.makeFixedLabel("<html>DUPLICATE OBSERVATION<br>JUSTIFICATION:</html>"), 2);
        componentCollection.remember((JComponent)this.makeWrappedTextArea(DUPLICATEOBSERVATION, 2, 4), 9);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new ScienceGoalInfoPanel(SGINFO));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new TimeRequestPanel());
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private String multiLineLabelHtmlString(List<?> list) {
        return this.multiLineLabelHtmlString(list, null);
    }

    private String multiLineLabelHtmlString(List<?> list, String string) {
        if (list.isEmpty()) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = list.iterator();
        stringBuilder.append("<html><center>");
        stringBuilder.append(iterator.next() + "&nbsp;").append(string);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            stringBuilder.append("<br>");
            if (obj == null) continue;
            stringBuilder.append(obj.toString() + "&nbsp;").append(string);
        }
        stringBuilder.append("</center></html>");
        return stringBuilder.toString();
    }

    protected void updateLabel(JLabel jLabel, String string) {
        jLabel.setText(string);
    }

    @Override
    protected void updateLabel(FieldID fieldID, String string) {
        JComponent jComponent = this.retrieve(fieldID);
        if (jComponent instanceof JLabel) {
            this.updateLabel((JLabel)jComponent, string);
        } else if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setText(string);
        }
    }

    private String formatCoIs(Investigator[] investigatorArray) {
        if (investigatorArray == null || investigatorArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(investigatorArray[0].getFullName());
        for (int i = 1; i < investigatorArray.length; ++i) {
            stringBuilder.append("; ").append(investigatorArray[i].getFullName());
        }
        return stringBuilder.toString();
    }

    private String formatInvestigators(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(", ");
        }
        return StringUtils.stripEnd((String)stringBuilder.toString(), (String)", ");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == TITLEPANEL) {
            BannerPanel bannerPanel = (BannerPanel)this.retrieve(fieldID);
            bannerPanel.update((ProposalSummaryParameters)object);
            return;
        }
        if (fieldID == COINAMES) {
            this.updateLabel(fieldID, this.formatCoIs((Investigator[])object));
            return;
        }
        if (fieldID == COPINAMES) {
            this.updateLabel(fieldID, this.formatCoIs((Investigator[])object));
            return;
        }
        if (fieldID == PICONTACTINFO) {
            if (object == null) {
                return;
            }
            PIContactInfo pIContactInfo = (PIContactInfo)object;
            this.updateLabel(PIEMAIL, pIContactInfo.getInfo(ProposalSummaryParameters.PIContactProperty.EMAIL));
            this.updateLabel(PIINSTITUTE, pIContactInfo.getInfo(ProposalSummaryParameters.PIContactProperty.INSTITUTE));
            return;
        }
        if (fieldID == DUPLICATEOBSERVATION) {
            if (object == null) {
                return;
            }
            String string = (String)object;
            this.updateLabel(fieldID, string);
            return;
        }
        if (fieldID == SGINFO) {
            List list = (List)object;
            ScienceGoalInfoPanel scienceGoalInfoPanel = (ScienceGoalInfoPanel)this.retrieve(fieldID);
            scienceGoalInfoPanel.update(list);
            return;
        }
        if (TOTAL12MTIME == fieldID || TOTAL7MTIME == fieldID) {
            Time time = (Time)object;
            if (object != null) {
                time.convertToUnit(Time.UNIT_H);
                this.updateLabel(fieldID, TextUtils.format(time, 0, 1));
            }
            return;
        }
        if (TOTALTPTIME == fieldID) {
            Time time = (Time)object;
            if (object != null) {
                time.convertToUnit(Time.UNIT_H);
                this.updateLabel(fieldID, TextUtils.format(time, 0, 1));
            }
            return;
        }
        this.updateLabel(fieldID, (String)object);
    }

    @Override
    public PdfExporter getPageExporter() {
        return new ProposalCoverSheetExporter(this.createOffView());
    }

    class ScienceGoalInfoPanel
    extends JPanel {
        private static final long serialVersionUID = -232284467526372012L;
        private final JLabel sgNameLabel;
        private final JLabel sourceLabel;
        private final JLabel bandLabel;
        private final JLabel angularResLabel;
        private final JLabel lasLabel;
        private final JLabel useACALabel;
        private final JLabel sgNumber;

        ScienceGoalInfoPanel(FieldID fieldID) {
            this.sgNameLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.sourceLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.bandLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.angularResLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.lasLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.useACALabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.sgNumber = ProposalSummaryView.this.makeLabel();
            ProposalSummaryView.this.register(this, fieldID);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            ProposalSummaryView.this.addComponent(this, gridBagLayout, gridBagConstraints, ProposalSummaryView.this.makeFixedLabel("REPRESENTATIVE SCIENCE GOALS (UP TO FIRST 30)"));
            ComponentCollection componentCollection = new ComponentCollection();
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("SCIENCE GOAL"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("POSITION"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("BAND"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("ANG.RES.(\")"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("LAS.(\")"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("ACA?"));
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
            componentCollection = new ComponentCollection();
            componentCollection.remember(this.sgNameLabel);
            componentCollection.remember(this.sourceLabel);
            componentCollection.remember(this.bandLabel);
            componentCollection.remember(this.angularResLabel);
            componentCollection.remember(this.lasLabel);
            componentCollection.remember(this.useACALabel);
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(this.sgNumber, gridBagConstraints);
            this.add(this.sgNumber);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            LabelBuilder labelBuilder = ProposalSummaryView.this.makeFixedLabel(" ");
            gridBagLayout.setConstraints(labelBuilder, gridBagConstraints);
            this.add(labelBuilder);
        }

        private String format(String string) {
            return String.format("%20s", string).trim();
        }

        private String format(SkyCoordinates skyCoordinates) {
            StringBuilder stringBuilder = new StringBuilder();
            if (skyCoordinates.isGalactic()) {
                stringBuilder.append("Galactic: ");
                stringBuilder.append(String.format("%.3f, %.3f", skyCoordinates.getLongitude().getContent(), skyCoordinates.getLatitude().getContent()));
            } else {
                stringBuilder.append(skyCoordinates.getSystem());
                stringBuilder.append(skyCoordinates.formatRADec());
            }
            return stringBuilder.toString();
        }

        private String format(ReceiverBand receiverBand) {
            if (receiverBand == null) {
                return "Unknown";
            }
            return String.format("%d", receiverBand.getNumber());
        }

        private String format(Angle angle) {
            return String.format("%.3f", angle.getContentInUnits(Angle.UNIT_ARCSEC));
        }

        private String format(boolean bl) {
            return bl ? "Y" : "N";
        }

        private String formatACAUse(boolean bl, boolean bl2) {
            if (bl2) {
                return "Only";
            }
            return bl ? "Y" : "N";
        }

        void update(List<ScienceGoalInfo> list) {
            if (list == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            ArrayList<String> arrayList6 = new ArrayList<String>();
            int n = 30 < list.size() ? 30 : list.size();
            for (int i = 0; i < n; ++i) {
                ScienceGoalInfo scienceGoalInfo = list.get(i);
                arrayList.add(this.format(scienceGoalInfo.sgname));
                arrayList2.add(this.format(scienceGoalInfo.sourceCoordinates));
                arrayList3.add(this.format(scienceGoalInfo.receiverBand));
                AngularResolutionRenderer angularResolutionRenderer = new AngularResolutionRenderer("%.3f", Angle.UNIT_ARCSEC);
                arrayList4.add(angularResolutionRenderer.format(scienceGoalInfo.sg));
                arrayList5.add(this.format(scienceGoalInfo.largestAngularScale));
                arrayList6.add(this.formatACAUse(scienceGoalInfo.isACAUsed, scienceGoalInfo.isStandAloneACA));
            }
            ProposalSummaryView.this.updateLabel(this.sgNameLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList));
            ProposalSummaryView.this.updateLabel(this.sourceLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList2));
            ProposalSummaryView.this.updateLabel(this.bandLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList3));
            ProposalSummaryView.this.updateLabel(this.angularResLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList4));
            ProposalSummaryView.this.updateLabel(this.lasLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList5));
            ProposalSummaryView.this.updateLabel(this.useACALabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList6));
            ProposalSummaryView.this.updateLabel(this.sgNumber, String.format("Total # Science Goals : %d", list.size()));
        }
    }

    class RelatedProposalInfoPanel
    extends JPanel {
        private static final long serialVersionUID = -200813288979543772L;
        private final JLabel rpCodeLabel;
        private final JLabel rpTitleLabel;
        private final JLabel rpPINameLabel;

        RelatedProposalInfoPanel(FieldID fieldID) {
            this.rpCodeLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.rpTitleLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.rpPINameLabel = ProposalSummaryView.this.makeLabel().setCenter();
            ProposalSummaryView.this.register(this, fieldID);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            ProposalSummaryView.this.addComponent(this, gridBagLayout, gridBagConstraints, ProposalSummaryView.this.makeFixedLabel("RELATED PROPOSALS"));
            ComponentCollection componentCollection = new ComponentCollection();
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("CODE"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("TITLE"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("PI NAME"));
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
            componentCollection = new ComponentCollection();
            componentCollection.remember(this.rpCodeLabel);
            componentCollection.remember(this.rpTitleLabel);
            componentCollection.remember(this.rpPINameLabel);
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
        }

        void update(List<ProposalSummaryParameters.RelatedProposalInfo> list) {
            if (list == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                ProposalSummaryParameters.RelatedProposalInfo relatedProposalInfo = list.get(i);
                arrayList.add(relatedProposalInfo.code);
                arrayList2.add(relatedProposalInfo.title);
                arrayList3.add(relatedProposalInfo.piName);
            }
            ProposalSummaryView.this.updateLabel(this.rpCodeLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList));
            ProposalSummaryView.this.updateLabel(this.rpTitleLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList2));
            ProposalSummaryView.this.updateLabel(this.rpPINameLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList3));
        }
    }

    class PreviousProposalInfoPanel
    extends JPanel {
        private static final long serialVersionUID = -5296554403456717724L;
        private final JLabel ppCodeLabel;
        private final JLabel ppTitleLabel;
        private final JLabel ppPINameLabel;
        private final JLabel ppPublicationStatusLabel;

        PreviousProposalInfoPanel(FieldID fieldID) {
            this.ppCodeLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.ppTitleLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.ppPINameLabel = ProposalSummaryView.this.makeLabel().setCenter();
            this.ppPublicationStatusLabel = ProposalSummaryView.this.makeLabel().setCenter();
            ProposalSummaryView.this.register(this, fieldID);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            ProposalSummaryView.this.addComponent(this, gridBagLayout, gridBagConstraints, ProposalSummaryView.this.makeFixedLabel("PREVIOUS PROPOSALS"));
            ComponentCollection componentCollection = new ComponentCollection();
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("CODE"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("TITLE"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("PI NAME"));
            componentCollection.remember(ProposalSummaryView.this.makeFixedLabel("PUBLICATION STATUS"));
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
            componentCollection = new ComponentCollection();
            componentCollection.remember(this.ppCodeLabel);
            componentCollection.remember(this.ppTitleLabel);
            componentCollection.remember(this.ppPINameLabel);
            componentCollection.remember(this.ppPublicationStatusLabel);
            ProposalSummaryView.this.addComponentArray(this, gridBagLayout, gridBagConstraints, componentCollection);
        }

        void update(List<PreviousProposalInfo> list) {
            if (list == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                PreviousProposalInfo previousProposalInfo = list.get(i);
                arrayList.add(previousProposalInfo.code);
                arrayList2.add(previousProposalInfo.title);
                arrayList3.add(previousProposalInfo.piName);
                arrayList4.add(previousProposalInfo.publicationStatus);
            }
            ProposalSummaryView.this.updateLabel(this.ppCodeLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList));
            ProposalSummaryView.this.updateLabel(this.ppTitleLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList2));
            ProposalSummaryView.this.updateLabel(this.ppPINameLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList3));
            ProposalSummaryView.this.updateLabel(this.ppPublicationStatusLabel, ProposalSummaryView.this.multiLineLabelHtmlString(arrayList4));
        }
    }

    class TimeRequestPanel
    extends JPanel {
        private static final long serialVersionUID = -2413097409410187271L;

        TimeRequestPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)ProposalSummaryView.this.makeFixedLabel("<html><center>SCHEDULING TIME CONSTRAINTS</center></html>"), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)ProposalSummaryView.this.makeItemLabel(TIMECONSTRAINTS), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)ProposalSummaryView.this.makeFixedLabel("TIME ESTIMATES OVERRIDDEN ?"), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)ProposalSummaryView.this.makeItemLabel(EXTRATIME), gridBagConstraints);
        }
    }

    class BannerPanel
    extends JPanel {
        private static final long serialVersionUID = 432421427355989828L;
        private final JTextArea titleLabel;
        private final JLabel codeLabel;

        BannerPanel(FieldID fieldID) {
            ProposalSummaryView.this.register(this, fieldID);
            this.setBorder(ProposalSummaryView.this.createBorder());
            Font font = this.getFont();
            Font font2 = new Font(font.getName(), 1, 18);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 0.0;
            ImageIcon imageIcon = Icons.getIcon("alma_logo_45x64.png");
            JLabel jLabel = new JLabel(imageIcon);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridx;
            int n = (int)Math.ceil(3.0);
            this.titleLabel = ProposalSummaryView.this.makeTextArea(n, 40);
            this.titleLabel.setFont(font2);
            this.titleLabel.setBorder(null);
            this.titleLabel.setLineWrap(true);
            this.titleLabel.setWrapStyleWord(true);
            gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
            this.add(this.titleLabel);
            ++gridBagConstraints.gridx;
            this.codeLabel = ProposalSummaryView.this.makeLabel().setFontTo(font2).setBorderTo(null).setHorizontalAlignmentTo(4);
            gridBagLayout.setConstraints(this.codeLabel, gridBagConstraints);
            this.add(this.codeLabel);
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridx;
            Component component = Box.createHorizontalStrut(5);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.add(component);
        }

        void update(ProposalSummaryParameters proposalSummaryParameters) {
            String string = proposalSummaryParameters.title;
            string = string == null ? "" : string;
            int n = (int)Math.ceil((float)string.length() / 40.0f);
            this.titleLabel.setRows(n);
            this.titleLabel.setText(string);
            this.codeLabel.setText(proposalSummaryParameters.projectCode);
        }
    }

    protected class LabelBuilder
    extends JLabel {
        private static final long serialVersionUID = 4897185618092512397L;

        LabelBuilder() {
            this.setBorderTo(ProposalSummaryView.this.createBorder());
            this.setPlainFont();
        }

        LabelBuilder setHorizontalAlignmentTo(int n) {
            this.setHorizontalAlignment(n);
            return this;
        }

        LabelBuilder setBorderTo(Border border) {
            this.setBorder(border);
            return this;
        }

        LabelBuilder setCenter() {
            return this.setHorizontalAlignmentTo(0);
        }

        LabelBuilder setFieldIDTo(FieldID fieldID) {
            ProposalSummaryView.this.register(this, fieldID);
            return this;
        }

        LabelBuilder setTextTo(String string) {
            this.setText(string);
            this.getPreferredSize();
            return this;
        }

        LabelBuilder setFontTo(Font font) {
            this.setFont(font);
            return this;
        }

        LabelBuilder setBoldFont() {
            Font font = this.getFont();
            this.setFont(new Font(font.getName(), 1, font.getSize()));
            return this;
        }

        LabelBuilder setPlainFont() {
            Font font = this.getFont();
            this.setFont(new Font(font.getName(), 0, font.getSize()));
            return this;
        }

        LabelBuilder setFixed() {
            this.setOpaque(true);
            this.setBackground(Color.lightGray);
            this.setBoldFont();
            return this;
        }
    }
}

