/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.DefaultSummaryFeedbackPanelPrintable;
import alma.obsprep.services.summaryfeedback.PdfExportable;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public abstract class SummaryFeedbackView
extends EditorWithGridBagLayout
implements PdfExportable {
    protected final int SPACEWIDTH = 30;
    protected Color defaultBackgroundColor;

    public SummaryFeedbackView() {
    }

    public SummaryFeedbackView(Model model) {
        this.setModel(model);
        this.build();
        this.defaultBackgroundColor = this.getBackground();
        model.publish();
    }

    @Override
    public void set(JComponent jComponent, Object object) {
        String string;
        if (jComponent == null) {
            return;
        }
        String string2 = string = object == null ? null : object.toString();
        if (jComponent instanceof UnchangeableOTButtonGroup) {
            super.set((OTButtonGroup)jComponent, string);
        } else if (jComponent instanceof UnchangeableCheckBox) {
            super.set((JCheckBox)jComponent, (Boolean)object);
        } else {
            if (jComponent instanceof Table) {
                return;
            }
            if (jComponent instanceof ProposalSummaryView.LabelBuilder) {
                super.set((JLabel)jComponent, (String)object);
            } else {
                super.set(jComponent, object);
            }
        }
    }

    @Override
    protected JLabel makeLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    protected JLabel makeLabel(FieldID fieldID) {
        JLabel jLabel = new JLabel();
        this.register(jLabel, fieldID);
        return jLabel;
    }

    protected JTextArea makeTextArea(FieldID fieldID, int n, int n2) {
        JTextArea jTextArea = new JTextArea(null, null, n, n2);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        this.register(jTextArea, fieldID);
        return jTextArea;
    }

    protected OTButtonGroup makeButtonGroup(FieldID fieldID, Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return this.makeButtonGroup(fieldID, stringArray);
    }

    protected OTButtonGroup makeButtonGroup(FieldID fieldID, String[] stringArray) {
        UnchangeableOTButtonGroup unchangeableOTButtonGroup = new UnchangeableOTButtonGroup(stringArray);
        this.register(unchangeableOTButtonGroup, fieldID);
        return unchangeableOTButtonGroup;
    }

    protected JCheckBox makeCheckBox(FieldID fieldID) {
        return this.makeCheckBox(fieldID, "");
    }

    @Override
    protected JCheckBox makeCheckBox(FieldID fieldID, String string) {
        UnchangeableCheckBox unchangeableCheckBox = new UnchangeableCheckBox(string);
        this.register(unchangeableCheckBox, fieldID);
        return unchangeableCheckBox;
    }

    protected JSeparator addHorizontalSeparator(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JSeparator jSeparator = new JSeparator();
        int n = gridBagConstraints.fill;
        gridBagConstraints.fill = 2;
        this.addVerticalSpace(jComponent, gridBagLayout, gridBagConstraints, 3);
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, jSeparator);
        this.addVerticalSpace(jComponent, gridBagLayout, gridBagConstraints, 3);
        gridBagConstraints.fill = n;
        return jSeparator;
    }

    protected void addComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2, int n) {
        int n2 = gridBagConstraints.anchor;
        gridBagConstraints.anchor = n;
        super.addComponent(jComponent, gridBagLayout, gridBagConstraints, jComponent2);
        gridBagConstraints.anchor = n2;
    }

    protected void addComponent(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent2, int n, int n2) {
        int n3 = gridBagConstraints.anchor;
        int n4 = gridBagConstraints.fill;
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = n2;
        super.addComponent(jComponent, gridBagLayout, gridBagConstraints, jComponent2);
        gridBagConstraints.anchor = n3;
        gridBagConstraints.fill = n4;
    }

    protected void addComponentsLine(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, ComponentCollection componentCollection) {
        Box box = Box.createHorizontalBox();
        Iterator<JComponent> iterator = componentCollection.getComponents().iterator();
        if (iterator.hasNext()) {
            box.add(iterator.next());
        }
        while (iterator.hasNext()) {
            box.add(Box.createHorizontalStrut(30));
            box.add(iterator.next());
        }
        this.addComponent(jComponent, gridBagLayout, gridBagConstraints, box);
    }

    protected void updateLabel(FieldID fieldID, String string) {
        JLabel jLabel = (JLabel)this.retrieve(fieldID);
        jLabel.setText(string);
    }

    protected void updateLabel(FieldID fieldID, String string, String string2) {
        this.updateLabel(fieldID, string, string2, "", "");
    }

    protected void updateLabel(FieldID fieldID, String string, String string2, String string3, String string4) {
        String string5 = string3 + string + " : " + string2 + string4;
        this.updateLabel(fieldID, string5);
    }

    protected void updateUnchangableOTButtonGroup(FieldID fieldID, Object object) {
        UnchangeableOTButtonGroup unchangeableOTButtonGroup = (UnchangeableOTButtonGroup)this.retrieve(fieldID);
        if (object == null || object.toString().length() == 0) {
            unchangeableOTButtonGroup.clearSelection();
        } else {
            unchangeableOTButtonGroup.setSelectedItem(object);
        }
    }

    protected String concatlist(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            stringBuilder.append(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                String string = list.get(i);
                if (string == null) continue;
                stringBuilder.append(", ").append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected static void drawComponentBorders(Container container) {
        for (Component component : container.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    protected abstract SummaryFeedbackView createOffView();

    protected void setBackgroundToWhite() {
        this.setBackgroundToWhite(this);
    }

    private void setBackgroundToWhite(Component component) {
        if (component.getBackground() == this.defaultBackgroundColor && component instanceof JComponent) {
            ((JComponent)component).setBackground(Color.white);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.setBackgroundToWhite(component2);
            }
        }
    }

    protected Printable getPrintable() {
        return new DefaultSummaryFeedbackPanelPrintable(this);
    }

    @Override
    public PdfExporter getPageExporter() {
        return new DefaultPdfExporter(this.createOffView());
    }

    protected class UnchangeableOTButtonGroup
    extends OTButtonGroup {
        private String previousSelection;

        public UnchangeableOTButtonGroup(String[] stringArray) {
            super(stringArray);
            this.addActionListener(actionEvent -> {
                if (this.previousSelection == null) {
                    this.clearSelection();
                }
                this.setSelectedItem(this.previousSelection);
            });
            this.setFocusable(false);
        }

        public void setSelectedItem(Object object) {
            this.setSelectedItem(object == null ? (String)null : object.toString());
        }

        @Override
        public void setSelectedItem(String string) {
            this.previousSelection = string;
            if (string != null) {
                super.setSelectedItem(string);
            }
        }
    }

    protected class UnchangeableCheckBox
    extends JCheckBox {
        public UnchangeableCheckBox() {
            this(null, false);
        }

        public UnchangeableCheckBox(String string) {
            this(string, false);
        }

        public UnchangeableCheckBox(String string, boolean bl) {
            super(string, bl);
            this.setFocusable(false);
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            this.setSelected(!this.isSelected());
        }
    }
}

