/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.TimeT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.valuetypes.data.TimeData;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.math3.util.ArithmeticUtils;

public class Time
extends TimeData<Time>
implements Comparable<Time> {
    public static final String[] units_s_min_h = new String[]{UNIT_S, UNIT_MIN, UNIT_H};

    public Time(TimeT timeT) {
        super(timeT);
    }

    public static Time createTimeSec(double d) {
        Time time = TimeData.createTime();
        time.setContent(d);
        time.setUnit(UNIT_S);
        return time;
    }

    public static Time createTimeMin(double d) {
        Time time = TimeData.createTime();
        time.setContent(d);
        time.setUnit(UNIT_MIN);
        return time;
    }

    public String defaultUnit() {
        return this.unitMap().getDefaultUnit();
    }

    public String getFriendlyUnit() {
        if (this.isZero()) {
            return this.getUnit();
        }
        Object[] objectArray = this.unitMap().getUnitsSorted();
        String string = null;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            string = (String)objectArray[i];
            if (!(this.getContentInUnits(string) > 1.0)) continue;
            return string;
        }
        return string;
    }

    public Time convertToFriendlyUnit() {
        if (this.isZero()) {
            return this;
        }
        this.convertToUnit(this.getFriendlyUnit());
        return this;
    }

    public static Time max(Time time, Time time2) {
        if (time == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: a ");
        }
        if (time2 == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: b");
        }
        if (time.isGreaterThan((AbstractDoubleWithUnit)time2)) {
            return time;
        }
        if (time2.isGreaterThan((AbstractDoubleWithUnit)time)) {
            return time2;
        }
        return time;
    }

    public void aggregate(Time time) {
        double d = time.getContentInUnits(this.getUnit());
        this.setContent(this.getContent() + d);
    }

    public Time adjustToIntegerMultipleOf(Time time) {
        long l = (long)this.getContentInUnits(UNIT_MS);
        long l2 = (long)time.getContentInUnits(UNIT_MS);
        double d = (double)ArithmeticUtils.lcm((long)l, (long)l2) / 1000.0;
        return Time.createTimeSec(d);
    }

    public double getContentInUnits(String string) {
        double d = this.getContent();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        String string2 = this.getUnit();
        try {
            UnitMap unitMap = this.unitMap();
            double d2 = unitMap.getScale(string2);
            double d3 = unitMap.getScale(string);
            MathContext mathContext = new MathContext(10, RoundingMode.HALF_UP);
            BigDecimal bigDecimal = new BigDecimal(d);
            BigDecimal bigDecimal2 = new BigDecimal(d3);
            BigDecimal bigDecimal3 = new BigDecimal(d2);
            if (d2 > d3) {
                bigDecimal = bigDecimal.multiply(bigDecimal3.divide(bigDecimal2, mathContext), mathContext);
                d = bigDecimal.doubleValue();
            } else if (d2 < d3) {
                bigDecimal = bigDecimal.divide(bigDecimal2.divide(bigDecimal3, mathContext), mathContext);
                d = bigDecimal.doubleValue();
            }
        }
        catch (UnitException unitException) {
            throw new RuntimeException(this.getClass() + ": no conversion factor from current unit '" + string2 + "' to '" + string + "'");
        }
        return d;
    }

    public double getSecs() {
        return this.getContentInUnits(UNIT_S);
    }

    public double getMins() {
        return this.getContentInUnits(UNIT_MIN);
    }

    public double getHours() {
        return this.getContentInUnits(UNIT_H);
    }

    public String toString() {
        return "[H]=" + this.getContentInUnits(UNIT_H) + " [M]=" + this.getContentInUnits(UNIT_MIN) + " [S]=" + this.getContentInUnits(UNIT_S) + " [D]=" + this.getContentInUnits(UNIT_D);
    }
}

