/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering.visualization;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.visualization.Paintable;
import com.apporiented.algorithm.clustering.visualization.VCoord;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ClusterComponent
implements Paintable {
    private Cluster cluster;
    private VCoord linkPoint;
    private VCoord initPoint;
    private boolean printName;
    private int dotRadius = 2;
    private int namePadding = 6;
    private List<ClusterComponent> children;

    public List<ClusterComponent> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ClusterComponent>();
        }
        return this.children;
    }

    public int getNamePadding() {
        return this.namePadding;
    }

    public void setNamePadding(int n) {
        this.namePadding = n;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int n) {
        this.dotRadius = n;
    }

    public void setChildren(List<ClusterComponent> list) {
        this.children = list;
    }

    public VCoord getLinkPoint() {
        return this.linkPoint;
    }

    public void setLinkPoint(VCoord vCoord) {
        this.linkPoint = vCoord;
    }

    public VCoord getInitPoint() {
        return this.initPoint;
    }

    public void setInitPoint(VCoord vCoord) {
        this.initPoint = vCoord;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public boolean isPrintName() {
        return this.printName;
    }

    public void setPrintName(boolean bl) {
        this.printName = bl;
    }

    public ClusterComponent(Cluster cluster, boolean bl, VCoord vCoord) {
        this.printName = bl;
        this.cluster = cluster;
        this.initPoint = vCoord;
        this.linkPoint = vCoord;
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2, double d, double d2, boolean bl) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = (int)(this.initPoint.getX() * d + (double)n);
        int n4 = (int)(this.initPoint.getY() * d2 + (double)n2);
        int n5 = (int)(this.linkPoint.getX() * d + (double)n);
        int n6 = n4;
        graphics2D.fillOval(n3 - this.dotRadius, n4 - this.dotRadius, this.dotRadius * 2, this.dotRadius * 2);
        graphics2D.drawLine(n3, n4, n5, n6);
        if (this.cluster.isLeaf()) {
            graphics2D.drawString(this.cluster.getName(), n3 + this.namePadding, n4 + fontMetrics.getHeight() / 2 - 2);
        }
        if (bl && this.cluster.getDistance() != null && !this.cluster.getDistance().isNaN() && this.cluster.getDistance().getDistance() > 0.0) {
            String string = String.format("%.2f", this.cluster.getDistance().getDistance());
            Rectangle2D object = fontMetrics.getStringBounds(string, graphics2D);
            graphics2D.drawString(string, n3 - (int)object.getWidth(), n4 - 2);
        }
        n3 = n5;
        n4 = n6;
        n6 = (int)(this.linkPoint.getY() * d2 + (double)n2);
        graphics2D.drawLine(n3, n4, n5, n6);
        for (ClusterComponent clusterComponent : this.children) {
            clusterComponent.paint(graphics2D, n, n2, d, d2, bl);
        }
    }

    public double getRectMinX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double d = Math.min(this.initPoint.getX(), this.linkPoint.getX());
        for (ClusterComponent clusterComponent : this.getChildren()) {
            d = Math.min(d, clusterComponent.getRectMinX());
        }
        return d;
    }

    public double getRectMinY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double d = Math.min(this.initPoint.getY(), this.linkPoint.getY());
        for (ClusterComponent clusterComponent : this.getChildren()) {
            d = Math.min(d, clusterComponent.getRectMinY());
        }
        return d;
    }

    public double getRectMaxX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double d = Math.max(this.initPoint.getX(), this.linkPoint.getX());
        for (ClusterComponent clusterComponent : this.getChildren()) {
            d = Math.max(d, clusterComponent.getRectMaxX());
        }
        return d;
    }

    public double getRectMaxY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double d = Math.max(this.initPoint.getY(), this.linkPoint.getY());
        for (ClusterComponent clusterComponent : this.getChildren()) {
            d = Math.max(d, clusterComponent.getRectMaxY());
        }
        return d;
    }

    public int getNameWidth(Graphics2D graphics2D, boolean bl) {
        int n = 0;
        if (bl || this.cluster.isLeaf()) {
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.cluster.getName(), graphics2D);
            n = (int)rectangle2D.getWidth();
        }
        return n;
    }

    public int getMaxNameWidth(Graphics2D graphics2D, boolean bl) {
        int n = this.getNameWidth(graphics2D, bl);
        for (ClusterComponent clusterComponent : this.getChildren()) {
            int n2 = clusterComponent.getMaxNameWidth(graphics2D, bl);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

