/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive.zoom;

import alma.acs.logging.archive.zoom.FilesManager;
import alma.acs.logging.archive.zoom.ZoomException;
import alma.acs.logging.archive.zoom.ZoomProgressListener;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.FileNotFoundException;

public class ZoomManager {
    public static final String MIN_LEVEL_PROPERTY_NAME = "jlog.archive.zoom.MinLevel";
    public static final String MAX_LEVEL_PROPERTY_NAME = "jlog.archive.zoom.MaxLevel";
    public static final String FILES_LOCATION_PROPERTY_NAME = "jlog.archive.zoom.filesFolder";
    private FilesManager filesManager = null;
    private LogTypeHelper minLevel = LogTypeHelper.values()[0];
    private LogTypeHelper maxLevel = LogTypeHelper.DEBUG;
    private volatile boolean loadingLogs = false;

    public ZoomManager() {
        String minLvl;
        String folder = System.getProperty(FILES_LOCATION_PROPERTY_NAME);
        if (folder != null) {
            try {
                this.filesManager = new FilesManager(folder);
            }
            catch (ZoomException e) {
                System.out.println("Error instantiating the FilesManager: " + e.getMessage());
                System.out.println("Zoom disabled at startup.");
                this.filesManager = null;
            }
        }
        if ((minLvl = System.getProperty(MIN_LEVEL_PROPERTY_NAME)) != null && !minLvl.isEmpty()) {
            LogTypeHelper lvl = LogTypeHelper.fromLogTypeDescription((String)minLvl);
            if (lvl != null) {
                this.minLevel = lvl;
            } else {
                System.out.println("Property jlog.archive.zoom.MinLevel is wrong: default value used instead.");
            }
        } else {
            System.out.println("Default value used for jlog.archive.zoom.MinLevel: " + this.minLevel);
        }
        String maxLvl = System.getProperty(MAX_LEVEL_PROPERTY_NAME);
        if (maxLvl != null && !maxLvl.isEmpty()) {
            LogTypeHelper lvl = LogTypeHelper.fromLogTypeDescription((String)maxLvl);
            if (lvl != null) {
                this.maxLevel = lvl;
            } else {
                System.out.println("Property jlog.archive.zoom.MaxLevel is wrong: default value used instead.");
            }
        } else {
            System.out.println("Default value used for jlog.archive.zoom.MaxLevel: " + this.maxLevel);
        }
    }

    public ZoomManager(String folder, LogTypeHelper min, LogTypeHelper max) throws ZoomException {
        this.filesManager = new FilesManager(folder);
        try {
            this.setLevels(min, max);
        }
        catch (Exception e) {
            throw new ZoomException("Error setting levels", e);
        }
    }

    public boolean isAvailable() {
        if (this.filesManager == null || !this.filesManager.isOperational()) {
            return false;
        }
        if (this.minLevel == null && this.maxLevel != null) {
            return true;
        }
        if (this.minLevel != null && this.maxLevel == null) {
            return false;
        }
        return this.minLevel.ordinal() <= this.maxLevel.ordinal();
    }

    public void setFilesRepository(String folder) throws ZoomException {
        if (folder == null || folder.isEmpty()) {
            throw new IllegalArgumentException("The folder can't be null nor empty");
        }
        this.filesManager = new FilesManager(folder);
    }

    public void setLevels(LogTypeHelper min, LogTypeHelper max) {
        if (max == null) {
            throw new IllegalArgumentException("The max level can't be null");
        }
        if (min != null && min.ordinal() > max.ordinal()) {
            throw new IllegalArgumentException("Invalid levels [" + min + ", " + max + "]");
        }
        this.minLevel = min;
        this.maxLevel = max;
    }

    public String getRepository() {
        if (this.filesManager == null) {
            return null;
        }
        return this.filesManager.filesFolder;
    }

    public LogTypeHelper getMinLevel() {
        return this.minLevel;
    }

    public LogTypeHelper getMaxLevel() {
        return this.maxLevel;
    }

    public void zoom(String startDate, String endDate, ACSRemoteLogListener logListener, ZoomProgressListener zoomListener, ACSRemoteErrorListener errorListener) throws FileNotFoundException, ZoomException {
        if (!this.isAvailable()) {
            throw new ZoomException("Zoom not available");
        }
        if (this.loadingLogs) {
            throw new ZoomException("A zoom is already in progress");
        }
        this.loadingLogs = true;
        this.filesManager.getLogs(startDate, endDate, logListener, this.minLevel, this.maxLevel, zoomListener, errorListener);
        this.loadingLogs = false;
    }

    public boolean isLoadingLogs() {
        return this.loadingLogs;
    }

    public void stopZoom() {
        if (this.filesManager != null) {
            this.filesManager.stopLoading();
        }
    }
}

