/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive.zoom;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.logging.archive.zoom.ZoomException;
import alma.acs.logging.archive.zoom.ZoomManager;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.LogTypeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ZoomPrefsDlg
extends JDialog
implements ActionListener {
    private final LoggingClient loggingClient;
    private final ZoomManager zoomManager;
    private JComboBox minLevelCB;
    private JComboBox maxLevelCB;
    private String folder;
    private JLabel folderLbl = new JLabel();
    private JButton folderBtn = new JButton("Change...");
    private JButton okBtn = new JButton("Ok");
    private JButton cancelBtn = new JButton("Cancel");

    public ZoomPrefsDlg(LoggingClient logCli, ZoomManager manager) {
        if (logCli == null) {
            throw new IllegalArgumentException("The LoggingClient can't be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("The manager can't be null");
        }
        this.loggingClient = logCli;
        this.zoomManager = manager;
        this.folder = this.zoomManager.getRepository();
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ZoomPrefsDlg.this.initialize();
                ZoomPrefsDlg.this.pack();
                ZoomPrefsDlg.this.setVisible(true);
            }
        });
    }

    private void initialize() {
        this.setTitle("Drill down preferences");
        ImageIcon zoomIcon = new ImageIcon(LogTypeHelper.class.getResource("/zoom.png"));
        this.setIconImage(zoomIcon.getImage());
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel levelsPnl = new JPanel();
        levelsPnl.setBorder(BorderFactory.createTitledBorder("Levels"));
        levelsPnl.setLayout(new BoxLayout(levelsPnl, 1));
        JPanel minPnl = new JPanel();
        minPnl.add(new JLabel("Min log level to load: "));
        this.minLevelCB = this.buildLogLevelCB(this.zoomManager.getMinLevel());
        minPnl.add(this.minLevelCB);
        levelsPnl.add(minPnl);
        JPanel maxPnl = new JPanel();
        maxPnl.add(new JLabel("Max log level to load: "));
        this.maxLevelCB = this.buildLogLevelCB(this.zoomManager.getMaxLevel());
        maxPnl.add(this.maxLevelCB);
        levelsPnl.add(maxPnl);
        contentPanel.add(levelsPnl);
        JPanel folderPnl = new JPanel(new BorderLayout());
        folderPnl.setBorder(BorderFactory.createTitledBorder("Folder of XML files"));
        folderPnl.add((Component)this.folderBtn, "East");
        this.folderBtn.addActionListener(this);
        folderPnl.add((Component)this.folderLbl, "Center");
        this.setupFolderLbl();
        contentPanel.add(folderPnl);
        contentPanel.add(new JSeparator());
        JPanel buttonPnl = new JPanel(new BorderLayout());
        buttonPnl.add((Component)this.cancelBtn, "West");
        this.cancelBtn.addActionListener(this);
        buttonPnl.add((Component)this.okBtn, "East");
        this.okBtn.addActionListener(this);
        this.okBtn.setEnabled(this.folder != null);
        contentPanel.add(buttonPnl);
        this.rootPane.setContentPane(contentPanel);
    }

    private JComboBox buildLogLevelCB(LogTypeHelper initialLevel) {
        LogTypeHelper[] types = LogTypeHelper.values();
        boolean t = false;
        JComboBox<LogTypeHelper> temp = new JComboBox<LogTypeHelper>(types);
        LogTypeRenderer rendererCB = new LogTypeRenderer();
        if (initialLevel != null) {
            temp.setSelectedItem(initialLevel);
        } else {
            temp.setSelectedItem(LogTypeHelper.TRACE);
        }
        temp.setEditable(false);
        temp.setMaximumRowCount(LogTypeHelper.values().length);
        temp.setRenderer(rendererCB);
        return temp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            if (this.okPressed()) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getSource() == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.folderBtn) {
            JFileChooser fileChooser = new JFileChooser(this.folder);
            fileChooser.setFileSelectionMode(1);
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = fileChooser.getSelectedFile();
                this.folder = f.getAbsolutePath();
                this.setupFolderLbl();
            }
            this.okBtn.setEnabled(this.folder != null);
        } else {
            System.out.println("Unknown event: " + e.getSource());
        }
    }

    private boolean okPressed() {
        try {
            this.zoomManager.setFilesRepository(this.folder);
        }
        catch (ZoomException ze) {
            JOptionPane.showMessageDialog(this, "Invalid folder: " + ze.getMessage(), "Error selecting folder", 0);
            return false;
        }
        try {
            this.zoomManager.setLevels((LogTypeHelper)this.minLevelCB.getSelectedItem(), (LogTypeHelper)this.maxLevelCB.getSelectedItem());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid levels", "Error setting levels", 0);
            return false;
        }
        if (!this.zoomManager.isAvailable()) {
            int ret = JOptionPane.showConfirmDialog(this, "Current setup seems wrong.\nAccept anyhow?", "Are the values right?", 0, 2);
            return ret == 0;
        }
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isShowing()) {
            this.setLocationRelativeTo(this.loggingClient);
            this.toFront();
        }
    }

    private void setupFolderLbl() {
        if (this.folder == null || this.folder.isEmpty()) {
            this.folderLbl.setText("<UNDEFINED>");
        } else {
            this.folderLbl.setText(this.folder);
        }
    }
}

