/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.renderer;

import alma.acs.util.IsoDateFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DateRenderer
extends JLabel
implements TableCellRenderer {
    protected static final Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
    private Color bColor;
    private Color fColor;
    private final SimpleDateFormat longDateFormat = new IsoDateFormat();
    private final SimpleDateFormat shortDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean shortDate;

    public DateRenderer(boolean dateFormat) {
        this.shortDate = dateFormat;
        this.setPreferredSize(new Dimension(18, 18));
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.fColor = table.getSelectionForeground();
            this.bColor = table.getSelectionBackground();
        } else {
            this.fColor = table.getForeground();
            this.bColor = table.getBackground();
        }
        this.setForeground(this.fColor);
        this.setBackground(this.bColor);
        this.setFont(table.getFont());
        if (value == null) {
            return this;
        }
        if (this.shortDate) {
            this.setText(this.shortDateFormat.format((Date)value));
        } else {
            this.setText(this.longDateFormat.format((Date)value));
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.bColor);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g);
    }

    public void setShortDateFormat(boolean shortFormat) {
        this.shortDate = shortFormat;
    }
}

