/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import jsky.image.fits.codec.FITSData;
import jsky.image.fits.codec.FITSImage;

public class FITSDataFloat
extends FITSData {
    private FloatBuffer _mappedBuffer;

    public FITSDataFloat(FITSImage fitsImage) {
        super(fitsImage);
        MappedByteBuffer byteBuffer = fitsImage.getByteBuffer();
        if (byteBuffer != null) {
            this._mappedBuffer = byteBuffer.asFloatBuffer();
        }
    }

    @Override
    public Raster getTile(Raster tile, int subsample, int scaledWidth, int scaledHeight) throws IOException {
        DataBufferFloat dataBuffer = (DataBufferFloat)tile.getDataBuffer();
        float[] destArray = dataBuffer.getData();
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int x0 = tile.getMinX();
        int y0 = tile.getMinY();
        int x1 = Math.min(x0 + tw - 1, scaledWidth - 1);
        int y1 = Math.min(y0 + th - 1, scaledHeight - 1);
        int xWidth = x1 - x0 + 1;
        if (this._mappedBuffer != null) {
            int tmpY0 = y0;
            y0 = scaledHeight - y1 - 1;
            y1 = scaledHeight - tmpY0 - 1;
            if (subsample == 1) {
                for (int j = y1; j >= y0; --j) {
                    this._mappedBuffer.position(j * this._width + x0);
                    this._mappedBuffer.get(destArray, (y1 - j) * tw, xWidth);
                }
            } else {
                for (int j = y1; j >= y0; --j) {
                    int dst = (y1 - j) * tw;
                    int src = (j * this._width + x0) * subsample;
                    for (int i = x0; i <= x1; ++i) {
                        destArray[dst++] = this._mappedBuffer.get(src);
                        src += subsample;
                    }
                }
            }
        } else {
            this.fillTile(destArray, x0, y0, tw, th);
        }
        return tile;
    }

    @Override
    public Raster getPreviewImage(Raster tile, int factor) throws IOException {
        if (this._mappedBuffer != null) {
            return this.getTile(tile, factor, tile.getWidth(), tile.getHeight());
        }
        DataBufferFloat dataBuffer = (DataBufferFloat)tile.getDataBuffer();
        float[] destArray = dataBuffer.getData();
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int w = tw * factor;
        int h = th * factor;
        int m = 0;
        float[] line = new float[this._width];
        for (int j = 0; j < h; j += factor) {
            int n = m++ * tw;
            this.fillTile(line, 0, j, this._width, 1);
            for (int i = 0; i < w; i += factor) {
                destArray[n++] = line[i];
            }
        }
        return tile;
    }
}

