/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.WrongCDBDataTypeEx;
import alma.cdbErrType.wrappers.AcsJCDBFieldDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJWrongCDBDataTypeEx;
import com.cosylab.CDB.DAOPOA;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DAOImpl
extends DAOPOA {
    private final Logger logger;
    private Document document = null;

    public DAOImpl(String xmlEntityString, Logger logger) {
        this.logger = logger;
        SAXBuilder builder = new SAXBuilder();
        try {
            this.document = builder.build((Reader)new StringReader(xmlEntityString));
        }
        catch (JDOMException e) {
            logger.log(Level.SEVERE, "JDOM: Problems parsing DAO string");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IO: Problems parsing DAO string");
        }
    }

    private String getField(String fieldName, Document doc) throws CDBFieldDoesNotExistEx {
        if (doc != null) {
            Element current = doc.getRootElement();
            if (fieldName.equalsIgnoreCase("") || current.getName().equals(fieldName)) {
                return current.getAttributes().toString();
            }
            StringTokenizer st = new StringTokenizer(fieldName, "/");
            String field = st.nextToken();
            while (st.hasMoreTokens()) {
                if ((current = current.getChild(field)) == null) {
                    AcsJCDBFieldDoesNotExistEx ex = new AcsJCDBFieldDoesNotExistEx();
                    ex.setProperty("FieldName", fieldName);
                    throw ex.toCDBFieldDoesNotExistEx();
                }
                field = st.nextToken();
            }
            if (field.equals("_characteristics")) {
                return current.getAttributes().toString();
            }
            String value = current.getAttributeValue(field);
            if (value == null) {
                AcsJCDBFieldDoesNotExistEx ex = new AcsJCDBFieldDoesNotExistEx();
                ex.setProperty("FieldName", fieldName);
                throw ex.toCDBFieldDoesNotExistEx();
            }
            return value;
        }
        throw new AcsJCDBFieldDoesNotExistEx().toCDBFieldDoesNotExistEx();
    }

    public int get_long(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String value = this.getField(propertyName, this.document);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            AcsJWrongCDBDataTypeEx e2 = new AcsJWrongCDBDataTypeEx();
            e2.setProperty("Value", value);
            e2.setProperty("DataType", "long");
            e2.setProperty("PropertyName", propertyName);
            throw e2.toWrongCDBDataTypeEx();
        }
    }

    public double get_double(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String value = this.getField(propertyName, this.document);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            AcsJWrongCDBDataTypeEx e2 = new AcsJWrongCDBDataTypeEx();
            e2.setProperty("Value", value);
            e2.setProperty("DataType", "double");
            e2.setProperty("PropertyName", propertyName);
            throw e2.toWrongCDBDataTypeEx();
        }
    }

    public String get_string(String propertyName) throws CDBFieldDoesNotExistEx {
        return this.getField(propertyName, this.document);
    }

    public String get_field_data(String propertyName) throws CDBFieldDoesNotExistEx {
        return this.getField(propertyName, this.document);
    }

    public String[] get_string_seq(String propertyName) throws CDBFieldDoesNotExistEx {
        String value = this.getField(propertyName, this.document);
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] seq = new String[list.size()];
        list.toArray(seq);
        return seq;
    }

    public int[] get_long_seq(String propertyName) throws CDBFieldDoesNotExistEx, WrongCDBDataTypeEx {
        String value = this.getField(propertyName, this.document);
        ArrayList<Integer> list = new ArrayList<Integer>();
        String val = null;
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
                list.add(new Integer(val));
            }
        }
        catch (NumberFormatException nfe) {
            throw new WrongCDBDataTypeEx();
        }
        int[] seq = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            seq[i] = (Integer)list.get(i);
        }
        return seq;
    }

    public double[] get_double_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String value = this.getField(propertyName, this.document);
        ArrayList<Double> list = new ArrayList<Double>();
        String val = null;
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
                list.add(new Double(val));
            }
        }
        catch (NumberFormatException nfe) {
            throw new WrongCDBDataTypeEx();
        }
        double[] seq = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            seq[i] = (Double)list.get(i);
        }
        return seq;
    }

    public void destroy() {
    }
}

