/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import java.sql.Date;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class SearchParameters {
    public static final Integer DO_NOT_SEARCH_DATE_CRITERIA = new Integer(-2);
    public static final Integer BEFORE_DATE_CRITERIA = new Integer(-1);
    public static final Integer ON_DATE_CRITERIA = new Integer(0);
    public static final Integer AFTER_DATE_CRITERIA = new Integer(1);
    public static final Integer RANGE_DATE_CRITERIA = new Integer(2);
    private Integer sourceBandMeasurementsLimit = -1;
    private Integer limit;
    private Object[] catalogues = new Object[0];
    private Object[] types = new Object[0];
    private String name;
    private Double ra;
    private Double dec;
    private Double radius;
    private Object[] ranges = new Object[0];
    private Double fLower;
    private Double fUpper;
    private Double fluxMin;
    private Double fluxMax;
    private Double degreeMin;
    private Double degreeMax;
    private Double angleMin;
    private Double angleMax;
    private Double uvMin;
    private Double uvMax;
    private Double spectralIndexMin;
    private Double spectralIndexMax;
    private String sortBy;
    private boolean asc;
    private Date dateFrom;
    private Date dateTo;
    private Integer dateCriteria;
    private Integer validCriteria = 1;

    public SearchParameters() {
    }

    public SearchParameters(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc) {
        this.limit = limit;
        this.catalogues = catalogues;
        this.types = types;
        this.name = name;
        this.ra = ra;
        this.dec = dec;
        this.radius = radius;
        this.ranges = ranges;
        this.fLower = fLower;
        this.fUpper = fUpper;
        this.fluxMin = fluxMin;
        this.fluxMax = fluxMax;
        this.degreeMin = degreeMin;
        this.degreeMax = degreeMax;
        this.angleMin = angleMin;
        this.angleMax = angleMax;
        this.sortBy = sortBy;
        this.asc = asc;
    }

    public Double getUvMin() {
        return this.uvMin;
    }

    public void setUvMin(Double uvMin) {
        this.uvMin = uvMin;
    }

    public Double getUvMax() {
        return this.uvMax;
    }

    public void setUvMax(Double uvMax) {
        this.uvMax = uvMax;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Object[] getCatalogues() {
        return this.catalogues;
    }

    public Object[] getTypes() {
        return this.types;
    }

    public String getName() {
        return this.name;
    }

    public Double getRa() {
        return this.ra;
    }

    public Double getDec() {
        return this.dec;
    }

    public Double getRadius() {
        return this.radius;
    }

    public Object[] getRanges() {
        return this.ranges;
    }

    public Double getFLower() {
        return this.fLower;
    }

    public Double getFUpper() {
        return this.fUpper;
    }

    public Double getFluxMin() {
        return this.fluxMin;
    }

    public Double getFluxMax() {
        return this.fluxMax;
    }

    public Double getDegreeMin() {
        return this.degreeMin;
    }

    public Double getDegreeMax() {
        return this.degreeMax;
    }

    public Double getAngleMin() {
        return this.angleMin;
    }

    public Double getAngleMax() {
        return this.angleMax;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public boolean getAsc() {
        return this.asc;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public Date getDateTo() {
        if (this.dateTo != null && this.dateTo.equals(this.dateFrom)) {
            this.dateCriteria = ON_DATE_CRITERIA;
            this.extendToDateByOneDay();
        }
        return this.dateTo;
    }

    private void extendToDateByOneDay() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.dateTo.getTime());
        ((Calendar)calendar).add(5, 1);
        ((Calendar)calendar).add(14, -1);
        this.dateTo = new Date(calendar.getTimeInMillis());
    }

    public Integer getValidCriteria() {
        return this.validCriteria;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setCatalogues(Object[] catalogues) {
        this.catalogues = catalogues;
    }

    public void setTypes(Object[] types) {
        this.types = types;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRa(Double ra) {
        this.ra = ra;
    }

    public void setDec(Double dec) {
        this.dec = dec;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public void setRanges(Object[] ranges) {
        this.ranges = ranges;
    }

    public void setFLower(Double fLower) {
        this.fLower = fLower;
    }

    public void setFUpper(Double fUpper) {
        this.fUpper = fUpper;
    }

    public void setFluxMin(Double fluxMin) {
        this.fluxMin = fluxMin;
    }

    public void setFluxMax(Double fluxMax) {
        this.fluxMax = fluxMax;
    }

    public void setDegreeMin(Double degreeMin) {
        this.degreeMin = degreeMin;
    }

    public void setDegreeMax(Double degreeMax) {
        this.degreeMax = degreeMax;
    }

    public void setAngleMin(Double angleMin) {
        this.angleMin = angleMin;
    }

    public void setAngleMax(Double angleMax) {
        this.angleMax = angleMax;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public void setValidCriteria(Integer validCriteria) {
        this.validCriteria = validCriteria;
    }

    public Integer getDateCriteria() {
        if (this.dateCriteria == null) {
            if (this.dateFrom == null) {
                this.dateCriteria = this.dateTo == null ? DO_NOT_SEARCH_DATE_CRITERIA : BEFORE_DATE_CRITERIA;
            } else if (this.dateTo == null) {
                this.dateCriteria = AFTER_DATE_CRITERIA;
            } else {
                this.dateCriteria = this.dateFrom.equals(this.dateTo) ? ON_DATE_CRITERIA : RANGE_DATE_CRITERIA;
                this.extendToDateByOneDay();
            }
        }
        return this.dateCriteria;
    }

    public String toString() {
        return "SearchParameters [" + (String)(this.sourceBandMeasurementsLimit != null ? "sourceBandMeasurementsLimit=" + this.sourceBandMeasurementsLimit + ", " : "") + (String)(this.limit != null ? "limit=" + this.limit + ", " : "") + (String)(this.catalogues != null ? "catalogues=" + Arrays.toString(this.catalogues) + ", " : "") + (String)(this.types != null ? "types=" + Arrays.toString(this.types) + ", " : "") + (String)(this.name != null ? "name=" + this.name + ", " : "") + (String)(this.ra != null ? "ra=" + this.ra + ", " : "") + (String)(this.dec != null ? "dec=" + this.dec + ", " : "") + (String)(this.radius != null ? "radius=" + this.radius + ", " : "") + (String)(this.ranges != null ? "ranges=" + Arrays.toString(this.ranges) + ", " : "") + (String)(this.fLower != null ? "fLower=" + this.fLower + ", " : "") + (String)(this.fUpper != null ? "fUpper=" + this.fUpper + ", " : "") + (String)(this.fluxMin != null ? "fluxMin=" + this.fluxMin + ", " : "") + (String)(this.fluxMax != null ? "fluxMax=" + this.fluxMax + ", " : "") + (String)(this.degreeMin != null ? "degreeMin=" + this.degreeMin + ", " : "") + (String)(this.degreeMax != null ? "degreeMax=" + this.degreeMax + ", " : "") + (String)(this.angleMin != null ? "angleMin=" + this.angleMin + ", " : "") + (String)(this.angleMax != null ? "angleMax=" + this.angleMax + ", " : "") + (String)(this.uvMin != null ? "uvMin=" + this.uvMin + ", " : "") + (String)(this.uvMax != null ? "uvMax=" + this.uvMax + ", " : "") + (String)(this.sortBy != null ? "sortBy=" + this.sortBy + ", " : "") + "asc=" + this.asc + ", " + (String)(this.dateFrom != null ? "dateFrom=" + this.dateFrom + ", " : "") + (String)(this.dateTo != null ? "dateTo=" + this.dateTo + ", " : "") + (String)(this.dateCriteria != null ? "dateCriteria=" + this.dateCriteria + ", " : "") + (String)(this.validCriteria != null ? "validCriteria=" + this.validCriteria : "") + "]";
    }

    public Integer getSourceBandMeasurementsLimit() {
        return this.sourceBandMeasurementsLimit;
    }

    public void setSourceBandMeasurementsLimit(Integer sourceBandMeasurementsLimit) {
        this.sourceBandMeasurementsLimit = sourceBandMeasurementsLimit;
    }

    public Double getSpectralIndexMin() {
        return this.spectralIndexMin;
    }

    public void setSpectralIndexMin(Double spectralIndexMin) {
        this.spectralIndexMin = spectralIndexMin;
    }

    public Double getSpectralIndexMax() {
        return this.spectralIndexMax;
    }

    public void setSpectralIndexMax(Double spectralIndexMax) {
        this.spectralIndexMax = spectralIndexMax;
    }
}

