/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.validators.ValidationUtils;

public abstract class IdentityConstraint
extends Annotated {
    private String _id = null;
    private String _name = null;
    private IdentitySelector _selector = null;
    private final Vector<IdentityField> _fields = new Vector(3);

    protected IdentityConstraint(String name) throws SchemaException {
        this.setName(name);
    }

    public void addField(IdentityField field) {
        if (field != null) {
            this._fields.add(field);
        }
    }

    public Enumeration<IdentityField> getFields() {
        return this._fields.elements();
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public IdentitySelector getSelector() {
        return this._selector;
    }

    public boolean removeField(IdentityField field) {
        return this._fields.remove(field);
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setName(String name) throws SchemaException {
        if (name == null) {
            throw new SchemaException("The name of an IdentityConstraint must not be null.");
        }
        this._name = name;
    }

    public void setSelector(IdentitySelector selector) throws SchemaException {
        if (selector == null) {
            throw new SchemaException("The selector of an IdentityConstraint must not be null.");
        }
        this._selector = selector;
    }

    @Override
    public abstract short getStructureType();

    @Override
    public void validate() throws ValidationException {
        String err = null;
        if (!ValidationUtils.isNCName(this._name)) {
            err = "The name of an IdentityConstraint must be an NCName.";
        } else if (this._selector == null) {
            err = "Selector for IdentityConstraint cannot be null.";
        } else if (this._fields.size() < 1) {
            err = "There must be at least one 'field' in an identity constraint.";
        }
        if (err != null) {
            throw new ValidationException(err);
        }
    }
}

