/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class ComponentReader {
    private SchemaContext _schemaContext;
    private Locator _documentLocator;
    private URIResolver _uriResolver;

    private ComponentReader() {
    }

    protected ComponentReader(SchemaContext schemaContext) {
        this();
        this._schemaContext = schemaContext;
    }

    public abstract String elementName();

    public abstract Object getObject();

    public void finish() throws XMLException {
    }

    public Resolver getResolver() {
        return this._schemaContext.getSchemaResolver();
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setResolver(Resolver resolver) {
        this._schemaContext.setSchemaResolver(resolver);
    }

    public void setURIResolver(URIResolver uriResolver) {
        this._uriResolver = uriResolver;
    }

    public static boolean isWhiteSpace(char[] chars, int start, int length) {
        int max = start + length;
        block3: for (int i = start; i < max; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public void error(String err) throws XMLException {
        if (this.getDocumentLocator() != null) {
            err = (String)err + "\n   line: " + this.getDocumentLocator().getLineNumber();
        }
        throw new XMLException((String)err);
    }

    public void error(Exception ex) throws XMLException {
        if (this.getDocumentLocator() != null) {
            String err = "An error occured at line: " + this.getDocumentLocator().getLineNumber();
            throw new XMLException(err, ex);
        }
        throw new XMLException(ex);
    }

    public void illegalAttribute(String attName) throws XMLException {
        String err = "Illegal attribute '" + attName + "' found on element <" + this.elementName() + ">.";
        if (this.getDocumentLocator() != null) {
            err = err + "\n   line: " + this.getDocumentLocator().getLineNumber();
        }
        throw new XMLException(err);
    }

    public void illegalElement(String name) throws XMLException {
        String err = "Illegal element '" + name + "' found as child of <" + this.elementName() + ">.";
        if (this.getDocumentLocator() != null) {
            err = err + "\n   line: " + this.getDocumentLocator().getLineNumber();
        }
        throw new XMLException(err);
    }

    public void redefinedElement(String name) throws XMLException {
        this.redefinedElement(name, null);
    }

    public void redefinedElement(String name, String xtraInfo) throws XMLException {
        String err = "redefintion of element '" + name + "' within element <" + this.elementName() + ">.";
        if (this.getDocumentLocator() != null) {
            err = err + "\n   line: " + this.getDocumentLocator().getLineNumber();
        }
        if (xtraInfo != null) {
            err = err + "\n   " + xtraInfo;
        }
        throw new XMLException(err + "\n");
    }

    public void outOfOrder(String name) throws XMLException {
        String err = "out of order element <" + name + "> found in <" + this.elementName() + ">.";
        throw new XMLException(err);
    }

    public static int toInt(String str) throws IllegalArgumentException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            String err = str + " is not a valid integer. ";
            throw new IllegalArgumentException(err);
        }
    }

    public Locator getDocumentLocator() {
        return this._documentLocator;
    }

    public void setDocumentLocator(Locator documentLocator) {
        this._documentLocator = documentLocator;
    }

    public void characters(char[] chars, int start, int length) throws XMLException {
    }

    public void endElement(String name, String namespace) throws XMLException {
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
    }

    public void setSchemaContext(SchemaContext schemaContext) {
        this._schemaContext = schemaContext;
    }

    public SchemaContext getSchemaContext() {
        return this._schemaContext;
    }

    protected void parseSchema(Parser parser, SchemaUnmarshaller schemaUnmarshaller, URILocation uri, String schemaLocation, String reason) throws SchemaException {
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            InputSource source = new InputSource(uri.getReader());
            source.setSystemId(uri.getAbsoluteURI());
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SchemaException("Error reading " + reason + " file '" + schemaLocation + "'");
        }
        catch (SAXException sx) {
            throw new SchemaException(sx);
        }
    }

    protected Parser createParser(String reason) throws SchemaException {
        Parser parser = null;
        try {
            parser = this.getSchemaContext().getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for " + reason);
        }
        return parser;
    }

    protected URILocation derive(Locator locator, String schemaLocation) throws XMLException {
        try {
            String documentBase = locator.getSystemId();
            if (documentBase != null && !documentBase.endsWith("/")) {
                documentBase = documentBase.substring(0, documentBase.lastIndexOf("/") + 1);
            }
            return this.getURIResolver().resolve(schemaLocation, documentBase);
        }
        catch (URIException ure) {
            throw new XMLException(ure);
        }
    }
}

