/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.GrabHandleFactory;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.Manipulator;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import jsky.image.graphics.RectangleGeometry;
import jsky.image.graphics.RectangleGrabHandleFactory;
import jsky.image.graphics.RotatableCanvasFigure;

public class RectangleManipulator
extends Manipulator {
    public RectangleManipulator() {
        this(new RectangleGrabHandleFactory());
    }

    public RectangleManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new Rotater());
    }

    private RectangleGeometry getGeometry() {
        Figure child = this.getChild();
        if (child instanceof RotatableCanvasFigure) {
            return ((RotatableCanvasFigure)child).getGeometry();
        }
        return null;
    }

    public FigureDecorator newInstance(Figure f) {
        RectangleManipulator m = new RectangleManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        return m;
    }

    public void refresh() {
        RectangleGeometry geometry = this.getGeometry();
        if (geometry != null) {
            geometry.refresh(this.getChild());
        }
    }

    public void setChild(Figure child) {
        super.setChild(child);
        this.clearGrabHandles();
        if (child != null) {
            RectangleGeometry geometry = this.getGeometry();
            if (geometry == null) {
                return;
            }
            Iterator i = geometry.sites();
            while (i.hasNext()) {
                Site site = (Site)i.next();
                GrabHandle g = this.getGrabHandleFactory().createGrabHandle(site);
                g.setParent((CanvasComponent)this);
                g.setInteractor((Interactor)this.getHandleInteractor());
                this.addGrabHandle(g);
            }
            this.relocateGrabHandles();
        }
    }

    protected static class Rotater
    extends DragInteractor {
        protected Rotater() {
        }

        public void translate(LayerEvent e, double dx, double dy) {
            AffineTransform af = new AffineTransform();
            GrabHandle grabHandle = (GrabHandle)e.getFigureSource();
            RectangleManipulator manipulator = (RectangleManipulator)grabHandle.getParent();
            RectangleGeometry geometry = manipulator.getGeometry();
            RotatableCanvasFigure roi = (RotatableCanvasFigure)manipulator.getChild();
            Point2D p = geometry.getRotateCenter();
            double cx = p.getX();
            double cy = p.getY();
            int id = grabHandle.getSite().getID();
            if (id == 0) {
                double x = e.getLayerX();
                double y = e.getLayerY();
                double x1 = x - dx - cx;
                double x2 = x - cx;
                double y1 = y - dy - cy;
                double y2 = y - cy;
                double angle = Math.atan2(y2, x2) - Math.atan2(y1, x1);
                af.setToRotation(angle, cx, cy);
                roi.transform(af);
            } else if (roi.isResizable()) {
                RectangularShape r1 = (RectangularShape)geometry.getRect().clone();
                grabHandle.translate(dx, dy);
                RectangularShape r2 = geometry.getRect();
                double angle = geometry.getRotateAngle();
                af.concatenate(AffineTransform.getRotateInstance(angle, cx, cy));
                af.concatenate(CanvasUtilities.computeTransform((RectangularShape)r1, (RectangularShape)r2));
                af.concatenate(AffineTransform.getRotateInstance(-angle, cx, cy));
                roi.transform(af);
            }
        }
    }
}

