/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public final class ClipboardHelper {
    private static Object contents = null;
    private static ClipboardHelper requestor = new ClipboardHelper();
    private static EventListenerList listenerList = new EventListenerList();

    private ClipboardHelper() {
    }

    public static void setClipboard(Object arg) {
        if (arg instanceof String) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard cb = toolkit.getSystemClipboard();
                StringSelection s = new StringSelection((String)arg);
                cb.setContents(s, s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        contents = arg;
        ClipboardHelper.fireChange();
    }

    public static Object getClipboard() {
        Object result = contents;
        return result;
    }

    public static void addChangeListener(ChangeListener l) {
        listenerList.add(ChangeListener.class, l);
    }

    public static void removeChangeListener(ChangeListener l) {
        listenerList.remove(ChangeListener.class, l);
    }

    protected static void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(new Object());
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }
}

