/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsky.util.I18N;
import jsky.util.gui.PrintUtil;
import jsky.util.gui.ProgressPanel;

public class PrintableJTable
extends JTable
implements Printable {
    private static final I18N _I18N = I18N.getInstance(PrintableJTable.class);
    private int _maxNumPage = 1;
    private String _title = "Table Contents";
    private PrintUtil _printUtil;

    public PrintableJTable() {
    }

    public PrintableJTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public PrintableJTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public PrintableJTable(TableModel dm) {
        super(dm);
    }

    public PrintableJTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public PrintableJTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public PrintableJTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void showPrintDialog(String title) throws PrinterException {
        this.setTitle(title);
        this.showPrintDialog();
    }

    public void showPrintDialog() throws PrinterException {
        if (this._printUtil == null) {
            this._printUtil = new PrintUtil(this, this._title);
        } else {
            this._printUtil.setTitle(this._title);
        }
        this._printUtil.print();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.white);
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)(fontHeight * 2);
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.getColumnModel().getTotalColumnWidth();
        double scale = 0.8333333333333334;
        if (tableWidth >= pageWidth) {
            scale = Math.min(pageWidth / tableWidth, scale);
        }
        double headerHeightOnPage = (double)this.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)this.getRowHeight() * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.getRowCount() / (double)numRowsOnAPage);
        int pageNum = pageIndex + 1;
        ProgressPanel progressPanel = this._printUtil.getProgressPanel();
        progressPanel.setProgress(pageNum * 100 / totalNumPages);
        String pageNumInfo = _I18N.getString("pageOf", new Object[]{new Integer(pageNum), new Integer(totalNumPages)});
        progressPanel.setText(pageNumInfo);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        String title = this.getTitle();
        if (title.length() != 0) {
            if (pageNum > 1) {
                title = title + " " + _I18N.getString("cont");
            }
            g2.drawString(title, 0, fontHeight - fontDesent);
        }
        g2.drawString(pageNumInfo, (int)pageWidth / 2 - 35, (int)(pageFormat.getImageableHeight() - (double)fontDesent));
        g2.translate(0.0, headerHeightOnPage + (double)fontHeight);
        g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageNum == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0, (int)((double)pageIndex * pageHeightForTable));
        g2.translate(0, (int)(-headerHeightOnPage));
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.getTableHeader().paint(g2);
        return 0;
    }
}

