/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.lang.reflect.Array;

public class Arrays {
    private Arrays() {
    }

    public static double sum(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
            }
            return sum;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double mean(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
                ++count;
            }
            return sum / (double)count;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double minimum(Object array) {
        try {
            int n = Array.getLength(array);
            double min = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d > min) continue;
                min = d;
            }
            return min;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double maximum(Object array) {
        try {
            int n = Array.getLength(array);
            double max = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d < max) continue;
                max = d;
            }
            return max;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static int size(Object array) {
        return array != null && array.getClass().isArray() ? Array.getLength(array) : 0;
    }
}

