/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import uk.ac.starlink.table.BeanStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.TextTableWriter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.KeepColumnFilter;
import uk.ac.starlink.ttools.filter.StatsFilter;
import uk.ac.starlink.ttools.mode.ColStats;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class StatsMode
implements ProcessingMode {
    private static final ValueInfo ROWCOUNT_INFO = new DefaultValueInfo("Total Rows", Long.class);

    public Parameter[] getAssociatedParameters() {
        return new Parameter[0];
    }

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Calculates and displays univariate statistics for each", "of the numeric columns in the table.", "The following entries are shown for each column as appropriate:", "<ul>", "<li>mean</li>", "<li>population standard deviation</li>", "<li>minimum</li>", "<li>maximum</li>", "<li>number of non-null entries</li>", "</ul>", "</p>", "<p>See the " + DocUtils.filterRef(new StatsFilter()) + " filter", "for more flexible statistical calculations.", "</p>"});
    }

    public TableConsumer createConsumer(Environment env) {
        final PrintStream out = env.getOutputStream();
        return new TableConsumer(){

            public void consume(StarTable table) throws IOException {
                new TextTableWriter().writeStarTable(StatsMode.makeStatsTable(table), (OutputStream)out);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StarTable makeStatsTable(StarTable table) throws IOException {
        BeanStarTable statsTable;
        int ncol = table.getColumnCount();
        Object[] stats = new ColStats[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            stats[icol] = ColStats.makeColStats(table.getColumnInfo(icol));
        }
        RowSequence rseq = table.getRowSequence();
        long nrow = 0L;
        try {
            while (rseq.next()) {
                ++nrow;
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    stats[icol].acceptDatum(row[icol]);
                }
            }
        }
        finally {
            rseq.close();
        }
        try {
            statsTable = new BeanStarTable(ColStats.class);
        }
        catch (IntrospectionException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Introspection Error???"))).initCause(e));
        }
        statsTable.setData(stats);
        String columns = "column mean stdDev min max good ";
        statsTable = KeepColumnFilter.keepColumnTable((StarTable)statsTable, columns);
        statsTable.setParameter(new DescribedValue(ROWCOUNT_INFO, (Object)new Long(nrow)));
        return statsTable;
    }
}

