/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;

public class GraphSurface
implements PlotSurface {
    private final JComponent component_;
    private Rectangle bounds_;
    private double xlo_;
    private double xhi_;
    private double ylo_;
    private double yhi_;
    private boolean xLog_;
    private boolean yLog_;
    private boolean xFlip_;
    private boolean yFlip_;

    public GraphSurface(JComponent component, boolean xLog, boolean yLog, boolean xFlip, boolean yFlip) {
        this.component_ = component;
        this.xLog_ = xLog;
        this.yLog_ = yLog;
        this.xFlip_ = xFlip;
        this.yFlip_ = yFlip;
    }

    public Shape getClip() {
        return this.bounds_;
    }

    public JComponent getComponent() {
        return this.component_;
    }

    public void setDataRange(double xlo, double ylo, double xhi, double yhi) {
        this.xlo_ = xlo;
        this.ylo_ = ylo;
        this.xhi_ = xhi;
        this.yhi_ = yhi;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds_ = new Rectangle(bounds);
    }

    public Point dataToGraphics(double x, double y, boolean insideOnly) {
        int ipx;
        if (insideOnly && (x < this.xlo_ || x > this.xhi_ || y < this.ylo_ || y > this.yhi_)) {
            return null;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return null;
        }
        double rx = this.xLog_ ? (x > 0.0 ? Math.log(x / this.xlo_) / Math.log(this.xhi_ / this.xlo_) : Double.NEGATIVE_INFINITY) : (x - this.xlo_) / (this.xhi_ - this.xlo_);
        double ry = this.yLog_ ? (y > 0.0 ? Math.log(y / this.ylo_) / Math.log(this.yhi_ / this.ylo_) : Double.NEGATIVE_INFINITY) : (y - this.ylo_) / (this.yhi_ - this.ylo_);
        if (this.xFlip_) {
            rx = 1.0 - rx;
        }
        if (!this.yFlip_) {
            ry = 1.0 - ry;
        }
        double px = (double)this.bounds_.x + rx * (double)this.bounds_.width;
        double py = (double)this.bounds_.y + ry * (double)this.bounds_.height;
        int n = px > 1.073741823E9 ? 0x3FFFFFFF : (ipx = px < -1.073741823E9 ? -1073741823 : (int)px);
        int ipy = py > 1.073741823E9 ? 0x3FFFFFFF : (py < -1.073741823E9 ? -1073741823 : (int)py);
        return new Point(ipx, ipy);
    }

    public double[] graphicsToData(int px, int py, boolean insideOnly) {
        if (insideOnly && (px < this.bounds_.x || px > this.bounds_.x + this.bounds_.width || py < this.bounds_.y || py > this.bounds_.y + this.bounds_.height)) {
            return null;
        }
        double rx = (double)(px - this.bounds_.x) / (double)this.bounds_.width;
        double ry = (double)(py - this.bounds_.y) / (double)this.bounds_.height;
        if (this.xFlip_) {
            rx = 1.0 - rx;
        }
        if (!this.yFlip_) {
            ry = 1.0 - ry;
        }
        return new double[]{this.xLog_ ? this.xlo_ * Math.exp(rx * Math.log(this.xhi_ / this.xlo_)) : this.xlo_ + rx * (this.xhi_ - this.xlo_), this.yLog_ ? this.ylo_ * Math.exp(ry * Math.log(this.yhi_ / this.ylo_)) : this.ylo_ + ry * (this.yhi_ - this.ylo_)};
    }

    public void setState(PlotState state) {
    }

    public void paintSurface(Graphics g) {
    }

    public String toString() {
        return this.bounds_ + " -> " + new Rectangle2D.Double(this.xlo_, this.ylo_, this.xhi_ - this.xlo_, this.yhi_ - this.ylo_);
    }
}

