/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;
import ij.util.Tools;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(ScaleDialog.class);
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi;
        double measured = 0.0;
        double known = 1.0;
        double aspectRatio = 1.0;
        String unit = "cm";
        boolean global1 = this.imp.getGlobalCalibration() != null;
        Calibration cal = this.imp.getCalibration();
        Calibration calOrig = cal.copy();
        boolean isCalibrated = cal.scaled();
        String scale = "<no scale>";
        int digits = 2;
        if (isCalibrated) {
            measured = 1.0 / cal.pixelWidth;
            digits = Tools.getDecimalPlaces(measured, measured);
            known = 1.0;
            aspectRatio = cal.pixelHeight / cal.pixelWidth;
            unit = cal.getUnit();
            scale = IJ.d2s(measured, digits) + " pixels/" + unit;
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof Line) {
            measured = ((Line)roi).getRawLength();
            known = 0.0;
        }
        SetScaleDialog gd = new SetScaleDialog("Set Scale", scale);
        gd.addNumericField("Distance in Pixels:", measured, digits, 8, null);
        gd.addNumericField("Known Distance:", known, 2, 8, null);
        gd.addNumericField("Pixel Aspect Ratio:", aspectRatio, 1, 8, null);
        gd.addStringField("Unit of Length:", unit);
        gd.addMessage("Scale: 12345.789 pixels per centimeter");
        gd.addCheckbox("Global", global1);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        measured = gd.getNextNumber();
        known = gd.getNextNumber();
        aspectRatio = gd.getNextNumber();
        unit = gd.getNextString();
        if (unit.equals("um")) {
            unit = "\u00b5m";
        } else if (unit.equals("A")) {
            unit = "\u00c5";
        }
        boolean global2 = gd.getNextBoolean();
        if (measured != 0.0 && known == 0.0) {
            this.imp.setGlobalCalibration(global2 ? cal : null);
            return;
        }
        if (measured <= 0.0 || unit.startsWith("pixel") || unit.startsWith("Pixel") || unit.equals("")) {
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
            cal.setUnit("pixel");
        } else {
            cal.pixelWidth = known / measured;
            cal.pixelHeight = aspectRatio != 0.0 ? cal.pixelWidth * aspectRatio : cal.pixelWidth;
            cal.setUnit(unit);
        }
        if (!cal.equals(calOrig)) {
            this.imp.setCalibration(cal);
        }
        this.imp.setGlobalCalibration(global2 ? cal : null);
        if (global2 || global2 != global1) {
            WindowManager.repaintImageWindows();
        } else {
            this.imp.repaintWindow();
        }
    }
}

