/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class UndefinedData
extends Data {
    long byteSize;
    byte[] data;

    public UndefinedData(Header h) throws FitsException {
        int size = 1;
        for (int i = 0; i < h.getIntValue("NAXIS"); ++i) {
            size *= h.getIntValue("NAXIS" + (i + 1));
        }
        size += h.getIntValue("PCOUNT");
        if (h.getIntValue("GCOUNT") > 1) {
            size *= h.getIntValue("GCOUNT");
        }
        this.data = new byte[size *= Math.abs(h.getIntValue("BITPIX") / 8)];
        this.byteSize = size;
    }

    public UndefinedData(Object x) {
        this.byteSize = ArrayFuncs.computeLSize(x);
        this.data = new byte[(int)this.byteSize];
    }

    @Override
    protected void fillHeader(Header head) {
        try {
            head.setXtension("UNKNOWN");
            head.setBitpix(8);
            head.setNaxes(1);
            head.addValue("NAXIS1", this.byteSize, " Number of Bytes ");
            head.addValue("PCOUNT", 0L, (String)null);
            head.addValue("GCOUNT", 1L, (String)null);
            head.addValue("EXTEND", true, "Extensions are permitted");
        }
        catch (HeaderCardException e) {
            System.err.println("Unable to create unknown header:" + e);
        }
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        if (i instanceof RandomAccess) {
            try {
                i.skipBytes(this.byteSize);
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip over data:" + e);
            }
        }
        try {
            i.readFully(this.data);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read unknown data:" + e);
        }
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            i.skipBytes(pad);
        }
        catch (EOFException e) {
            throw new PaddingException("EOF skipping padding in undefined data", this);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding in undefined data");
        }
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (this.data == null) {
            this.getData();
        }
        if (this.data == null) {
            throw new FitsException("Null unknown data");
        }
        try {
            o.write(this.data);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on unknown data write" + e);
        }
        byte[] padding = new byte[FitsUtil.padding(this.getTrueSize())];
        try {
            o.write(padding);
        }
        catch (IOException e) {
            throw new FitsException("Error writing padding: " + e);
        }
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    @Override
    public Object getData() {
        if (this.data == null) {
            try {
                FitsUtil.reposition(this.input, this.fileOffset);
                this.input.read(this.data);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.data;
    }
}

