/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.slf4j.Logger;

public class AOM {
    private AOMListener aomListener;
    private final boolean unique;
    private final Logger logger;
    private final Map objectMap = new HashMap();
    private final Map servantMap;
    private final HashSet etherealisationList = new HashSet();
    private final HashSet incarnationList = new HashSet();
    private final HashSet deactivationList = new HashSet();
    private BlockingQueue removalQueue = new LinkedBlockingQueue();
    AOMRemoval aomRemoval;
    private static int count = 0;
    private static final Object END = new Object();

    protected AOM(boolean _unique, Logger _logger) {
        this.unique = _unique;
        this.logger = _logger;
        this.aomRemoval = new AOMRemoval();
        this.servantMap = this.unique ? new HashMap() : Collections.EMPTY_MAP;
        this.aomRemoval.setDaemon(true);
        this.aomRemoval.start();
    }

    protected void add(byte[] oid, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        this.add(oidbak, servant);
    }

    protected synchronized void add(ByteArrayKey oidbak, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        byte[] oid = oidbak.getBytes();
        while (this.incarnationList.contains(oidbak) || this.etherealisationList.contains(oidbak) || this.deactivationList.contains(oidbak) || this.servantMap.containsKey(servant) && this.deactivationList.contains(this.servantMap.get(servant))) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(oidbak, servant);
        if (this.unique) {
            this.servantMap.put(servant, oidbak);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "object is activated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectActivated(oid, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.add(this.aomListener, listener);
    }

    synchronized boolean isDeactivating(ByteArrayKey oid) {
        return this.deactivationList.contains(oid);
    }

    protected synchronized boolean contains(Servant servant) {
        return this._contains(servant);
    }

    private boolean _contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.containsValue(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] result = new StringPair[this.objectMap.size()];
        Iterator en = this.objectMap.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            ByteArrayKey oidbak = (ByteArrayKey)en.next();
            result[i] = new StringPair(oidbak.toString(), this.objectMap.get(oidbak).getClass().getName());
        }
        return result;
    }

    protected synchronized byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        ByteArrayKey oidbak = (ByteArrayKey)this.servantMap.get(servant);
        if (oidbak != null) {
            return oidbak.getBytes();
        }
        return null;
    }

    protected Servant getServant(byte[] oid) {
        return this.getServant(new ByteArrayKey(oid));
    }

    protected synchronized Servant getServant(ByteArrayKey oid) {
        return (Servant)this.objectMap.get(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Servant incarnate(ByteArrayKey oidbak, ServantActivator servant_activator, org.omg.PortableServer.POA poa) throws ForwardRequest {
        byte[] oid = oidbak.getBytes();
        Servant servant = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "incarnate");
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            return (Servant)this.objectMap.get(oidbak);
        }
        if (servant_activator == null) {
            throw new OBJ_ADAPTER("Servant Activator for " + POAUtil.convert(oid) + " was null.");
        }
        this.incarnationList.add(oidbak);
        try {
            servant = servant_activator.incarnate(oid, poa);
        }
        finally {
            this.incarnationList.remove(oidbak);
            this.notifyAll();
        }
        if (servant == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (incarnate returns null)");
            }
        } else if (this.unique && this.servantMap.containsKey(servant)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (unique_id policy is violated)");
            }
            servant = null;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("oid: " + POAUtil.convert(oid) + "servant is incarnated");
            }
            if (this.aomListener != null) {
                this.aomListener.servantIncarnated(oid, servant);
            }
            try {
                this.add(oidbak, servant);
            }
            catch (ObjectAlreadyActive e) {
                throw new POAInternalError("error: object already active (AOM.incarnate)");
            }
            catch (ServantAlreadyActive e) {
                throw new POAInternalError("error: servant already active (AOM.incarnate)");
            }
        }
        ((POA)poa).getORB().set_delegate(servant);
        return servant;
    }

    synchronized void remove(ByteArrayKey oidbak, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) throws ObjectNotActive {
        if (!this.objectMap.containsKey(oidbak) || this.deactivationList.contains(oidbak)) {
            throw new ObjectNotActive();
        }
        this.deactivationList.add(oidbak);
        RemovalStruct rs = new RemovalStruct(oidbak, requestController, servantActivator, poa, cleanupInProgress);
        try {
            this.removalQueue.put(rs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _remove(ByteArrayKey oidbak, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) {
        byte[] oid = oidbak.getBytes();
        if (!this.objectMap.containsKey(oidbak)) {
            this.deactivationList.remove(oidbak);
            return;
        }
        if (requestController != null) {
            requestController.waitForObjectCompletion(oidbak);
        }
        try {
            this.actualRemove(oidbak, servantActivator, poa, cleanupInProgress, oid);
        }
        finally {
            if (requestController != null) {
                requestController.freeObject(oidbak);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void actualRemove(ByteArrayKey oidbak, ServantActivator servantActivator, POA poa, boolean cleanupInProgress, byte[] oid) {
        Servant servant = (Servant)this.objectMap.get(oidbak);
        if (servant == null) {
            this.deactivationList.remove(oidbak);
            return;
        }
        this.objectMap.remove(oidbak);
        if (this.unique) {
            this.servantMap.remove(servant);
        }
        this.deactivationList.remove(oidbak);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "object is deactivated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectDeactivated(oid, servant, this.objectMap.size());
        }
        if (servantActivator == null) {
            this.notifyAll();
            return;
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.etherealisationList.add(oidbak);
        try {
            servantActivator.etherealize(oid, (org.omg.PortableServer.POA)poa, servant, cleanupInProgress, this._contains(servant));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is etherealized");
            }
            if (this.aomListener != null) {
                this.aomListener.servantEtherialized(oid, servant);
            }
        }
        catch (SystemException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "exception occurred during servant etherialisation: " + e.getMessage());
            }
        }
        finally {
            this.etherealisationList.remove(oidbak);
            this.notifyAll();
        }
    }

    protected synchronized void removeAll(ServantActivator servant_activator, POA poa, boolean cleanup_in_progress) {
        for (ByteArrayKey oid : new HashSet(this.objectMap.keySet())) {
            this._remove(oid, null, servant_activator, poa, cleanup_in_progress);
        }
    }

    protected synchronized void removeAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, listener);
    }

    protected synchronized int size() {
        return this.objectMap.size();
    }

    class RemovalStruct {
        ByteArrayKey oidbak;
        RequestController requestController;
        ServantActivator servantActivator;
        POA poa;
        boolean cleanupInProgress;

        public RemovalStruct(ByteArrayKey oidbak, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) {
            this.oidbak = oidbak;
            this.requestController = requestController;
            this.servantActivator = servantActivator;
            this.poa = poa;
            this.cleanupInProgress = cleanupInProgress;
        }
    }

    class AOMRemoval
    extends Thread {
        private boolean run;

        public AOMRemoval() {
            super("AOMRemoval-" + ++count);
            this.run = true;
        }

        public void end() {
            this.run = false;
            try {
                AOM.this.removalQueue.put(END);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (this.run) {
                try {
                    Object rso = AOM.this.removalQueue.take();
                    if (rso == END) continue;
                    RemovalStruct rs = (RemovalStruct)rso;
                    AOM.this._remove(rs.oidbak, rs.requestController, rs.servantActivator, rs.poa, rs.cleanupInProgress);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

